/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server.mysql;

import com.googlecode.jdbw.DatabaseConnection;
import com.googlecode.jdbw.DatabaseTransaction;
import com.googlecode.jdbw.TransactionIsolation;
import com.googlecode.jdbw.objectstorage.ObjectFactory;
import com.googlecode.jdbw.objectstorage.Storable;
import com.googlecode.jdbw.objectstorage.TableMapping;
import com.googlecode.jdbw.objectstorage.TableMappingFactory;
import com.googlecode.jdbw.objectstorage.impl.DefaultTableMappingFactory;
import com.googlecode.jdbw.objectstorage.impl.JDBCObjectStorage;
import com.googlecode.jdbw.server.mysql.MySQLTableMapping;
import com.googlecode.jdbw.server.mysql.MySQLTableMappingFactory;
import com.googlecode.jdbw.util.BatchUpdateHandlerAdapter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLJDBCObjectStorage
extends JDBCObjectStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLJDBCObjectStorage.class);

    public MySQLJDBCObjectStorage(DatabaseConnection databaseConnection) {
        this(databaseConnection, new DefaultTableMappingFactory());
    }

    public MySQLJDBCObjectStorage(DatabaseConnection databaseConnection, TableMappingFactory tableMappingFactory) {
        super(databaseConnection, new MySQLTableMappingFactory(tableMappingFactory));
    }

    public MySQLJDBCObjectStorage(DatabaseConnection databaseConnection, TableMappingFactory tableMappingFactory, ObjectFactory objectFactory) {
        super(databaseConnection, new MySQLTableMappingFactory(tableMappingFactory), objectFactory);
    }

    public MySQLJDBCObjectStorage(DatabaseConnection databaseConnection, TableMappingFactory tableMappingFactory, ObjectFactory objectFactory, int retryAttempts) {
        super(databaseConnection, new MySQLTableMappingFactory(tableMappingFactory), objectFactory, retryAttempts);
    }

    @Override
    protected <O> void doPutAll(Class<O> objectType, Collection<O> objects, TableMapping tableMapping) throws SQLException {
        DatabaseTransaction transaction = null;
        try {
            String sql = ((MySQLTableMapping)tableMapping).getMySQLInsertOrUpdate();
            transaction = this.getDatabaseConnection().beginTransaction(TransactionIsolation.REPEATABLE_READ);
            ArrayList<Object[]> batch = new ArrayList<Object[]>();
            for (O o : objects) {
                batch.add(this.transform(tableMapping, (Storable)o));
            }
            transaction.batchWrite(new BatchUpdateHandlerAdapter(), sql, batch);
            transaction.commit();
        }
        catch (SQLException e) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
            }
            catch (SQLException e2) {
                LOGGER.debug("Database error when trying to rollback transaction after previous error (logged below)", (Throwable)e2);
            }
            throw e;
        }
    }
}

