/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server.mysql;

import com.googlecode.jdbw.DatabaseServerType;
import com.googlecode.jdbw.DatabaseServerTypes;
import com.googlecode.jdbw.JDBCDriverDescriptor;
import com.googlecode.jdbw.server.StandardDatabaseServer;
import com.googlecode.jdbw.server.mysql.MySQLDatabaseConnectionFactory;
import com.googlecode.jdbw.server.mysql.MySQLJDBCDriverDescriptor;

public class MySQLServer
extends StandardDatabaseServer {
    public static final int DEFAULT_MYSQL_PORT = 3306;

    public MySQLServer(String hostname, String catalog) {
        this(new MySQLJDBCDriverDescriptor(), hostname, 3306, catalog);
    }

    public MySQLServer(String hostname, int port, String catalog) {
        this(new MySQLJDBCDriverDescriptor(), hostname, port, catalog);
    }

    protected MySQLServer(JDBCDriverDescriptor driverDescriptor, String hostname, int port, String catalog) {
        super(driverDescriptor, hostname, port, catalog);
    }

    @Override
    public DatabaseServerType getServerType() {
        return DatabaseServerTypes.MYSQL;
    }

    @Override
    public MySQLDatabaseConnectionFactory newConnectionFactory() {
        return new MySQLDatabaseConnectionFactory(this.getDriverDescriptor().formatJDBCUrl(this.getHostname(), this.getPort(), this.getDefaultCatalog()));
    }
}

