/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server.mysql;

import com.googlecode.jdbw.objectstorage.TableMapping;
import com.googlecode.jdbw.objectstorage.impl.DelegatingTableMapping;
import com.googlecode.jdbw.server.mysql.MySQLDialect;

class MySQLTableMapping
extends DelegatingTableMapping {
    private final MySQLDialect dialect = new MySQLDialect();

    MySQLTableMapping(TableMapping backend) {
        super(backend);
    }

    String getMySQLInsertOrUpdate() {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(this.dialect.escapeIdentifier(this.getTableName()));
        sb.append(" (");
        sb.append(this.dialect.escapeIdentifier(this.getColumnName("id")));
        for (String fieldName : this.getFieldNames()) {
            sb.append(", ").append(this.dialect.escapeIdentifier(this.getColumnName(fieldName)));
        }
        sb.append(") VALUES(?");
        for (int i = 0; i < this.getFieldNames().size(); ++i) {
            sb.append(", ?");
        }
        sb.append(") ON DUPLICATE KEY UPDATE ");
        for (String fieldName : this.getFieldNames()) {
            sb.append(this.dialect.escapeIdentifier(this.getColumnName(fieldName)));
            sb.append(" = VALUES(");
            sb.append(this.dialect.escapeIdentifier(this.getColumnName(fieldName)));
            sb.append("), ");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }
}

