/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server.sybase;

import com.googlecode.jdbw.metadata.Catalog;
import com.googlecode.jdbw.metadata.DefaultServerMetaData;
import com.googlecode.jdbw.metadata.Index;
import com.googlecode.jdbw.metadata.Schema;
import com.googlecode.jdbw.metadata.Table;
import com.googlecode.jdbw.metadata.TableColumn;
import com.googlecode.jdbw.server.sybase.SybaseExecutor;
import com.googlecode.jdbw.util.MockResultSet;
import com.googlecode.jdbw.util.SQLWorker;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

class SybaseASEMetaDataResolver
extends DefaultServerMetaData {
    SybaseASEMetaDataResolver(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected ResultSet getSchemaMetadata(Connection pooledConnection, Catalog catalog, String schemaName) throws SQLException {
        return pooledConnection.getMetaData().getSchemas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableColumn> getColumns(Table table) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            ArrayList<TableColumn> result = new ArrayList<TableColumn>();
            ResultSet resultSet = this.getTableColumnMetadata(pooledConnection, table);
            while (resultSet.next()) {
                result.add(this.createTableColumn(table, resultSet.getInt("ORDINAL_POSITION"), resultSet.getString("COLUMN_NAME"), resultSet.getInt("DATA_TYPE"), resultSet.getString("TYPE_NAME"), resultSet.getInt("COLUMN_SIZE"), resultSet.getInt("DECIMAL_DIGITS"), resultSet.getInt("NULLABLE"), null));
            }
            ArrayList<TableColumn> arrayList = result;
            return arrayList;
        }
        finally {
            pooledConnection.close();
        }
    }

    @Override
    protected ResultSet getStoredProcedureMetadata(Connection pooledConnection, Schema schema, String procedureName) throws SQLException {
        SQLWorker worker = new SQLWorker(new SybaseExecutor(pooledConnection));
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (String foundProcedureName : worker.leftColumnAsString("SELECT name FROM " + schema.getCatalog().getName() + "..sysobjects WHERE type = 'P' ORDER BY name ASC", new Object[0])) {
            if (procedureName != null && !procedureName.equals(foundProcedureName)) continue;
            rows.add(new Object[]{null, null, procedureName});
        }
        return new MockResultSet(rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Index> getIndexes(Table table) throws SQLException {
        String indexName;
        Map<String, TableColumn> tableColumns = table.getColumnMap();
        Connection pooledConnection = this.dataSource.getConnection();
        SQLWorker worker = new SQLWorker(new SybaseExecutor(pooledConnection));
        String catalogName = table.getSchema().getCatalog().getName();
        String schemaName = table.getSchema().getName();
        List<Object[]> rows = worker.query("select i.name, i.status, i.status2 FROM " + catalogName + "." + schemaName + ".sysobjects o, " + "     " + catalogName + "." + schemaName + ".sysindexes i " + "WHERE o.name = ? AND o.type = 'U' AND " + "         o.id = i.id", table.getName());
        HashSet<String> clusteredIndexes = new HashSet<String>();
        for (Object[] row : rows) {
            indexName = row[0] != null ? row[0].toString().trim() : null;
            if (indexName == null || "".equals(indexName) || clusteredIndexes.contains(indexName)) continue;
            int status = (Integer)row[1];
            int status2 = (Integer)row[2];
            boolean clustered = (status & 0x10) > 0 || (status2 & 0x200) > 0;
            if (!clustered) continue;
            clusteredIndexes.add(indexName);
        }
        try {
            HashMap<String, Index> result = new HashMap<String, Index>();
            ResultSet resultSet = this.getIndexMetadata(pooledConnection, table);
            while (resultSet.next()) {
                indexName = resultSet.getString("INDEX_NAME");
                String columnName = resultSet.getString("COLUMN_NAME");
                if (indexName == null) continue;
                if (result.containsKey(indexName)) {
                    ((Index)result.get(indexName)).addColumn(tableColumns.get(columnName));
                    continue;
                }
                result.put(indexName, this.createIndex(table, indexName, clusteredIndexes.contains(indexName) ? (short)1 : 0, !resultSet.getBoolean("NON_UNIQUE"), tableColumns.get(columnName)));
            }
            List<Index> list = this.sortIndexList(new ArrayList<Index>(result.values()));
            return list;
        }
        finally {
            pooledConnection.close();
        }
    }
}

