/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server.sybase;

import com.googlecode.jdbw.metadata.Column;
import com.googlecode.jdbw.metadata.Index;
import com.googlecode.jdbw.metadata.Nullability;
import com.googlecode.jdbw.server.DefaultSQLDialect;
import com.googlecode.jdbw.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class SybaseASESQLDialect
extends DefaultSQLDialect {
    private static final String HEXES = "0123456789abcdef";

    @Override
    public String escapeString(String string) {
        return string.replaceAll("'", "''");
    }

    @Override
    public String getSingleLineCommentPrefix() {
        return "--";
    }

    @Override
    public String getDefaultSchemaName() {
        return "dbo";
    }

    private String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    @Override
    protected String formatBinary(Object value) {
        if (value instanceof byte[]) {
            return "0x" + this.getHex((byte[])value);
        }
        return super.formatBinary(value);
    }

    @Override
    public String[] getCreateTableStatement(String schemaName, String name, List<Column> columns, List<Index> indexes) {
        ArrayList<String> statements = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(name).append("(\n");
        for (Column column : columns) {
            sb.append("\t").append(column.getName()).append(" ");
            sb.append(this.getSybaseDatatype(column));
            if (column.getNullable() == Nullability.NOT_NULLABLE) {
                sb.append(" NOT NULL");
            } else {
                sb.append(" NULL");
            }
            sb.append(",\n");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append(")");
        statements.add(sb.toString());
        for (Index index : indexes) {
            sb = new StringBuilder("ALTER TABLE ");
            sb.append(name);
            sb.append(" ADD CONSTRAINT ");
            sb.append(index.getName());
            sb.append(" ");
            if (index.isPrimaryKey()) {
                sb.append("PRIMARY KEY ");
            } else if (index.isUnique()) {
                sb.append("UNIQUE ");
            }
            if (index.isClustered()) {
                sb.append("CLUSTERED ");
            }
            sb.append("(");
            sb.append(StringUtils.concatenateStringList(index.getColumnNames(), ","));
            sb.append(")");
            statements.add(sb.toString());
        }
        return statements.toArray(new String[0]);
    }

    private String getSybaseDatatype(Column column) {
        if (SybaseASESQLDialect.isBigDecimal(column.getSqlType())) {
            return "DECIMAL(" + column.getColumnSize() + ", " + column.getDecimalDigits() + ")";
        }
        if (SybaseASESQLDialect.isBinary(column.getSqlType())) {
            return "VARBINARY(" + column.getColumnSize() + ")";
        }
        if (SybaseASESQLDialect.isBoolean(column.getSqlType())) {
            return "BOOLEAN";
        }
        if (SybaseASESQLDialect.isDate(column.getSqlType())) {
            return "DATE";
        }
        if (SybaseASESQLDialect.isDatetime(column.getSqlType())) {
            return "DATETIME";
        }
        if (SybaseASESQLDialect.isFloatingPoint(column.getSqlType())) {
            return "FLOAT";
        }
        if (column.getSqlType() == -6) {
            return "TINYINT";
        }
        if (column.getSqlType() == 5) {
            return "SMALLINT";
        }
        if (column.getSqlType() == 4) {
            return "INT";
        }
        if (column.getSqlType() == -5) {
            return "DECIMAL(19,0)";
        }
        if (SybaseASESQLDialect.isInteger(column.getSqlType())) {
            return "INT";
        }
        if (SybaseASESQLDialect.isString(column.getSqlType())) {
            return "VARCHAR(" + column.getColumnSize() + ")";
        }
        if (SybaseASESQLDialect.isTime(column.getSqlType())) {
            return "TIME";
        }
        return "<UNKNOWN TYPE>";
    }
}

