/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server.sybase;

import com.googlecode.jdbw.DatabaseServerTypes;
import com.googlecode.jdbw.impl.AuthenticatingDatabaseConnectionFactory;

public class SybaseDatabaseConnectionFactory
extends AuthenticatingDatabaseConnectionFactory {
    SybaseDatabaseConnectionFactory(String jdbcUrl) {
        super(DatabaseServerTypes.SYBASE_ASE, jdbcUrl);
        this.setCharset("utf8");
    }

    @Override
    public SybaseDatabaseConnectionFactory setUsername(String username) {
        this.setConnectionProperty("USER", username);
        return this;
    }

    @Override
    public SybaseDatabaseConnectionFactory setPassword(String password) {
        this.setConnectionProperty("PASSWORD", password);
        return this;
    }

    public SybaseDatabaseConnectionFactory setApplicationName(String applicationName) {
        this.setConnectionProperty("APPLICATIONNAME", applicationName);
        return this;
    }

    public final SybaseDatabaseConnectionFactory setCharset(String charset) {
        this.setConnectionProperty("CHARSET", charset);
        return this;
    }
}

