/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.util;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

abstract class DelegatingConnection
implements Connection {
    protected Connection _conn = null;
    protected boolean _closed = false;
    private boolean _cacheState = true;
    private Boolean _autoCommitCached = null;
    private Boolean _readOnlyCached = null;

    DelegatingConnection(Connection c) {
        this._conn = c;
    }

    public String toString() {
        String s = null;
        Connection c = this.getInnermostDelegateInternal();
        if (c != null) {
            try {
                if (c.isClosed()) {
                    s = "connection is closed";
                } else {
                    DatabaseMetaData meta = c.getMetaData();
                    if (meta != null) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(meta.getURL());
                        sb.append(", UserName=");
                        sb.append(meta.getUserName());
                        sb.append(", ");
                        sb.append(meta.getDriverName());
                        s = sb.toString();
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (s == null) {
            s = super.toString();
        }
        return s;
    }

    public Connection getDelegate() {
        return this.getDelegateInternal();
    }

    protected Connection getDelegateInternal() {
        return this._conn;
    }

    public boolean innermostDelegateEquals(Connection c) {
        Connection innerCon = this.getInnermostDelegateInternal();
        if (innerCon == null) {
            return c == null;
        }
        return innerCon.equals(c);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Connection delegate = this.getInnermostDelegateInternal();
        if (obj instanceof DelegatingConnection) {
            DelegatingConnection c = (DelegatingConnection)obj;
            Connection cDelegate = c.getInnermostDelegateInternal();
            return delegate == cDelegate || delegate != null && delegate.equals(cDelegate);
        }
        return delegate.equals(obj);
    }

    public int hashCode() {
        Connection obj = this.getInnermostDelegateInternal();
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public Connection getInnermostDelegate() {
        return this.getInnermostDelegateInternal();
    }

    protected final Connection getInnermostDelegateInternal() {
        Connection c = this._conn;
        while (c != null && c instanceof DelegatingConnection) {
            if (this != (c = ((DelegatingConnection)c).getDelegateInternal())) continue;
            return null;
        }
        return c;
    }

    public void setDelegate(Connection c) {
        this._conn = c;
    }

    protected void handleException(SQLException e) throws SQLException {
        throw e;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this._conn.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this._conn.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this._conn.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this._conn.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._conn.clearWarnings();
    }

    @Override
    public void commit() throws SQLException {
        this._conn.commit();
    }

    public boolean getCacheState() {
        return this._cacheState;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this._cacheState && this._autoCommitCached != null) {
            return this._autoCommitCached;
        }
        this._autoCommitCached = this._conn.getAutoCommit();
        return this._autoCommitCached;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this._conn.getCatalog();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this._conn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this._conn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this._conn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._conn.getWarnings();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this._cacheState && this._readOnlyCached != null) {
            return this._readOnlyCached;
        }
        this._readOnlyCached = this._conn.isReadOnly();
        return this._readOnlyCached;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this._conn.nativeSQL(sql);
    }

    @Override
    public void rollback() throws SQLException {
        this._conn.rollback();
    }

    public void setCacheState(boolean cacheState) {
        this._cacheState = cacheState;
    }

    public void clearCachedState() {
        this._autoCommitCached = null;
        this._readOnlyCached = null;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this._conn.setAutoCommit(autoCommit);
            if (this._cacheState) {
                this._autoCommitCached = autoCommit;
            }
        }
        catch (SQLException e) {
            this._autoCommitCached = null;
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this._conn.setCatalog(catalog);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this._conn.setReadOnly(readOnly);
            if (this._cacheState) {
                this._readOnlyCached = readOnly;
            }
        }
        catch (SQLException e) {
            this._readOnlyCached = null;
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this._conn.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this._conn.setTypeMap(map);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed || this._conn.isClosed();
    }

    protected void checkOpen() throws SQLException {
        if (this._closed) {
            if (null != this._conn) {
                String label = "";
                try {
                    label = this._conn.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SQLException("Connection " + label + " is closed.");
            }
            throw new SQLException("Connection is null.");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._conn.getHoldability();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this._conn.setHoldability(holdability);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this._conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this._conn.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this._conn.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this._conn.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this._conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this._conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this._conn.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this._conn.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this._conn.prepareStatement(sql, columnNames);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass()) || this._conn.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        if (iface.isAssignableFrom(this._conn.getClass())) {
            return iface.cast(this._conn);
        }
        return this._conn.unwrap(iface);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this._conn.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this._conn.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this._conn.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this._conn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this._conn.createSQLXML();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this._conn.createStruct(typeName, attributes);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this._conn.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this._conn.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this._conn.setClientInfo(properties);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this._conn.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this._conn.getClientInfo(name);
    }
}

