/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.util;

import com.googlecode.jdbw.DataSourceFactory;
import com.googlecode.jdbw.util.DelegatingConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class OneSharedConnectionDataSource
implements DataSource {
    private final ArrayBlockingQueue<Connection> connectionQueue = new ArrayBlockingQueue(1);

    public OneSharedConnectionDataSource(Connection connection) {
        this.connectionQueue.add(connection);
    }

    public void close() {
        try {
            this.connectionQueue.poll().close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return new DelegatingConnection(this.connectionQueue.take()){

                @Override
                public void close() throws SQLException {
                    OneSharedConnectionDataSource.this.connectionQueue.add(this._conn);
                }
            };
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static class Factory
    implements DataSourceFactory {
        @Override
        public DataSource newDataSource(String jdbcUrl, Properties properties) {
            try {
                return new OneSharedConnectionDataSource(DriverManager.getConnection(jdbcUrl, properties));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close(DataSource previouslyConstructedDataSource) {
            ((OneSharedConnectionDataSource)previouslyConstructedDataSource).close();
        }
    }
}

