/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.util;

import com.googlecode.jdbw.ExecuteResultHandler;
import com.googlecode.jdbw.SQLExecutor;
import com.googlecode.jdbw.util.ExecuteResultHandlerAdapter;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SQLWorker {
    private final SQLExecutor executor;

    public SQLWorker(SQLExecutor executor) {
        this.executor = executor;
    }

    public List<Object[]> query(String SQL, Object ... parameters) throws SQLException {
        final ArrayList<Object[]> result = new ArrayList<Object[]>();
        this.executor.execute((ExecuteResultHandler)new ExecuteResultHandlerAdapter(){

            @Override
            public boolean nextRow(Object[] row) {
                result.add(row);
                return true;
            }
        }, SQL, parameters);
        return result;
    }

    public List<String[]> queryAsStrings(String SQL, Object ... parameters) throws SQLException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (Object[] row : this.query(SQL, parameters)) {
            String[] stringRow = new String[row.length];
            for (int i = 0; i < row.length; ++i) {
                stringRow[i] = row[i] == null ? null : row[i].toString();
            }
            result.add(stringRow);
        }
        return result;
    }

    public void write(String SQL, Object ... parameters) throws SQLException {
        this.executor.execute((ExecuteResultHandler)new ExecuteResultHandlerAdapter(), SQL, parameters);
    }

    public Object insert(String SQL, Object ... parameters) throws SQLException {
        final ArrayList autoGeneratedKeys = new ArrayList();
        this.executor.execute((ExecuteResultHandler)new ExecuteResultHandlerAdapter(){

            @Override
            public void onGeneratedKey(Object object) {
                autoGeneratedKeys.add(object);
            }
        }, SQL, parameters);
        if (autoGeneratedKeys.isEmpty()) {
            return null;
        }
        return autoGeneratedKeys.get(0);
    }

    public Object[] top(String SQL, Object ... parameters) throws SQLException {
        final ArrayList result = new ArrayList();
        this.executor.execute((ExecuteResultHandler)new ExecuteResultHandlerAdapter(){

            @Override
            public boolean nextRow(Object[] row) {
                result.add(row);
                return false;
            }
        }, 1, 0, SQL, parameters);
        return result.isEmpty() ? null : (Object[])result.get(0);
    }

    public String[] topAsString(String SQL, Object ... parameters) throws SQLException {
        Object[] rowAsObjects = this.top(SQL, parameters);
        String[] rowAsStrings = new String[rowAsObjects.length];
        for (int i = 0; i < rowAsObjects.length; ++i) {
            rowAsStrings[i] = rowAsObjects[i] != null ? rowAsObjects[i].toString() : null;
        }
        return rowAsStrings;
    }

    public List<Object> leftColumn(String SQL, Object ... parameters) throws SQLException {
        List<Object[]> allRows = this.query(SQL, parameters);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object[] row : allRows) {
            result.add(row[0]);
        }
        return result;
    }

    public List<String> leftColumnAsString(String SQL, Object ... parameters) throws SQLException {
        List<Object> leftColumn = this.leftColumn(SQL, parameters);
        ArrayList<String> result = new ArrayList<String>(leftColumn.size());
        for (Object value : leftColumn) {
            if (value == null) {
                result.add(null);
                continue;
            }
            result.add(value.toString());
        }
        return result;
    }

    public Object topLeftValue(String SQL, Object ... parameters) throws SQLException {
        Object[] row = this.top(SQL, parameters);
        if (row == null) {
            return null;
        }
        return row[0];
    }

    public String topLeftValueAsString(String SQL, Object ... parameters) throws SQLException {
        Object value = this.topLeftValue(SQL, parameters);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Integer topLeftValueAsInt(String SQL, Object ... parameters) throws SQLException {
        Object value = this.topLeftValue(SQL, parameters);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value.toString());
    }

    public Long topLeftValueAsLong(String SQL, Object ... parameters) throws SQLException {
        Object value = this.topLeftValue(SQL, parameters);
        if (value == null) {
            return null;
        }
        return Long.parseLong(value.toString());
    }

    public BigInteger topLeftValueAsBigInteger(String SQL, Object ... parameters) throws SQLException {
        Object value = this.topLeftValue(SQL, parameters);
        if (value == null) {
            return null;
        }
        return new BigInteger(value.toString());
    }
}

