/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.el;

import com.googlecode.jinahya.el.ELAttribute;
import com.googlecode.jinahya.el.ELElement;
import com.googlecode.jinahya.el.ELNode;
import com.googlecode.jinahya.el.ElementLocator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMElementLocator
extends ElementLocator<Document> {
    public static ElementLocator<Document> newInstance(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new IllegalArgumentException("no root element");
        }
        return DOMElementLocator.newInstance(element);
    }

    public static ElementLocator<Document> newInstance(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        return new DOMElementLocator(DOMElementLocator.parse(element));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getLocalName();
        ELElement _element = new ELElement(namespaceURI, localName);
        NamedNodeMap attributes = element.getAttributes();
        int attributeLength = attributes.getLength();
        for (int i = 0; i < attributeLength; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String attributeNamespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = attribute.getLocalName();
            String attributeValue = attribute.getNodeValue();
            _element.attributes.put(ELNode.express(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        String text = null;
        NodeList childNodes = element.getChildNodes();
        int length = childNodes.getLength();
        block5: for (int i = 0; i < length; ++i) {
            Node childNode = childNodes.item(i);
            switch (childNode.getNodeType()) {
                case 3: 
                case 4: {
                    if (text != null) continue block5;
                    text = childNode.getNodeValue();
                    continue block5;
                }
                case 1: {
                    _element.elements.add(DOMElementLocator.parse((Element)childNode));
                    continue block5;
                }
            }
        }
        if (_element.elements.isEmpty()) {
            _element.text = text;
        }
        return _element;
    }

    protected DOMElementLocator(ELElement root) {
        super(root);
    }

    @Override
    protected void print(ELElement root, Document document, Map<String, String> namespaces) {
        if (root == null) {
            throw new NullPointerException("null root");
        }
        if (document == null) {
            throw new NullPointerException("null document");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaces");
        }
        this.print(root, document, namespaces, document);
    }

    private void print(ELElement _element, Document document, Map<String, String> namesapces, Node parent) {
        if (_element == null) {
            throw new NullPointerException("null _element");
        }
        if (document == null) {
            throw new NullPointerException("null document");
        }
        if (namesapces == null) {
            throw new NullPointerException("null namespaces");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        Element element = document.createElementNS(_element.namespaceURI, DOMElementLocator.getQualifiedName(_element, namesapces));
        parent.appendChild(element);
        for (ELAttribute _attribute : _element.attributes.values()) {
            element.setAttributeNS(_attribute.namespaceURI, DOMElementLocator.getQualifiedName(_attribute, namesapces), _attribute.value);
        }
        if (_element.text != null) {
            element.appendChild(document.createTextNode(_element.text));
        } else {
            for (ELElement child : _element.elements) {
                this.print(child, document, namesapces, element);
            }
        }
    }
}

