/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.el;

import com.googlecode.jinahya.el.ELAttribute;
import com.googlecode.jinahya.el.ELElement;
import com.googlecode.jinahya.el.ELNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementLocator<D> {
    private final List<ELElement> path = new ArrayList<ELElement>();

    static String getQualifiedName(ELNode node, Map<String, String> namespaces) {
        if (node == null) {
            throw new NullPointerException("null node");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaceMap");
        }
        return ElementLocator.getQualifiedName(node.namespaceURI, node.localName, namespaces);
    }

    static String getQualifiedName(String namespaceURI, String localName, Map<String, String> namespaces) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaceMap");
        }
        if ("".equals(namespaceURI)) {
            return localName;
        }
        String namespacePrefix = namespaces.get(namespaceURI);
        if (namespacePrefix == null) {
            throw new RuntimeException("no namespace prefix for " + namespaceURI);
        }
        return namespacePrefix + ":" + localName;
    }

    protected ElementLocator(ELElement root) {
        if (root == null) {
            throw new NullPointerException("null root");
        }
        this.path.add(root);
    }

    public final int getChildCount(String localName) {
        return this.getChildCount("", localName);
    }

    public final int getChildCount(String namespaceURI, String localName) {
        int count = 0;
        for (ELElement child : this.getCurrent().elements) {
            if (!child.localName.equals(localName) || !child.namespaceURI.equals(namespaceURI)) continue;
            ++count;
        }
        return count;
    }

    public final ElementLocator<D> locateRoot() {
        while (this.path.size() > 1) {
            this.path.remove(this.path.size() - 1);
        }
        return this;
    }

    public final ElementLocator<D> locateParent() {
        if (this.path.size() == 1) {
            throw new IllegalStateException("no parent to locate");
        }
        this.path.remove(this.path.size() - 1);
        return this;
    }

    public final ElementLocator<D> locateChild(String localName, int index) {
        return this.locateChild("", localName, index);
    }

    public final ElementLocator<D> locateChild(String namespaceURI, String localName, int index) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        if (index < 0) {
            throw new IllegalArgumentException("negative index: " + index);
        }
        int count = 0;
        for (ELElement element : this.getCurrent().elements) {
            if (!element.localName.equals(localName) || !element.namespaceURI.equals(namespaceURI)) continue;
            if (count == index) {
                this.path.add(element);
                return this;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException("no child at " + index);
    }

    public final ElementLocator<D> addChild(String localName) {
        return this.addChild("", localName);
    }

    public final ElementLocator<D> addChild(String namespaceURI, String localName) {
        ELElement child = new ELElement(namespaceURI, localName);
        this.getCurrent().elements.add(child);
        this.path.add(child);
        return this;
    }

    public final String getText() {
        return this.getCurrent().text;
    }

    public final String getText(boolean parent) {
        String text = this.getText();
        if (parent) {
            this.locateParent();
        }
        return text;
    }

    public final ElementLocator<D> setText(String text) {
        this.getCurrent().text = text;
        return this;
    }

    public final ElementLocator<D> setText(String text, boolean parent) {
        this.setText(text);
        if (parent) {
            this.locateParent();
        }
        return this;
    }

    public final String getAttribute(String localName) {
        return this.getAttribute("", localName);
    }

    public final String getAttribute(String namespaceURI, String localName) {
        ELAttribute attribute = this.getCurrent().attributes.get(ELNode.express(namespaceURI, localName));
        if (attribute == null) {
            return null;
        }
        return attribute.value;
    }

    public final ElementLocator<D> setAttribute(String localName, String value) {
        return this.setAttribute("", localName, value);
    }

    public final ElementLocator<D> setAttribute(String namespaceURI, String localName, String value) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        if (value == null) {
            throw new NullPointerException("null value");
        }
        ELAttribute attribute = new ELAttribute(namespaceURI, localName, value);
        this.getCurrent().attributes.put(ELNode.express(attribute), attribute);
        return this;
    }

    public final void print(D document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        TreeMap<String, String> namespaces = new TreeMap<String, String>();
        ELElement root = this.path.get(0);
        for (String namespaceURI : root.getNamespaceURIs()) {
            namespaces.put(namespaceURI, null);
        }
        long index = 0L;
        for (Map.Entry entry : namespaces.entrySet()) {
            entry.setValue("ns" + index++);
        }
        namespaces.put("http://www.w3.org/XML/1998/namespace", "xml");
        this.print(this.path.get(0), document, Collections.unmodifiableMap(namespaces));
    }

    protected abstract void print(ELElement var1, D var2, Map<String, String> var3);

    public final void removeCurrent() {
        if (this.path.size() == 1) {
            throw new IllegalStateException("can't remove the root element");
        }
        ELElement element = this.getCurrent();
        this.locateParent().getCurrent().elements.remove(element);
    }

    protected final ELElement getCurrent() {
        return this.path.get(this.path.size() - 1);
    }

    public final String toJSON() {
        return this.path.get(0).toJSON();
    }
}

