/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.el;

import com.googlecode.jinahya.el.ELAttribute;
import com.googlecode.jinahya.el.ELElement;
import com.googlecode.jinahya.el.ELNode;
import com.googlecode.jinahya.el.ElementLocator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Parent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOMElementLocator
extends ElementLocator<Document> {
    public static ElementLocator<Document> newInstance(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element element = document.getRootElement();
        if (element == null) {
            throw new IllegalArgumentException("no root element");
        }
        return JDOMElementLocator.newInstance(element);
    }

    public static ElementLocator<Document> newInstance(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        return new JDOMElementLocator(JDOMElementLocator.parse(element));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getName();
        ELElement _element = new ELElement(namespaceURI, localName);
        List attributes = element.getAttributes();
        for (Attribute attribute : attributes) {
            String attributeNamespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = attribute.getName();
            String attributeValue = attribute.getValue();
            _element.attributes.put(ELNode.express(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        Object text = null;
        List children = element.getChildren();
        for (Element child : children) {
            _element.elements.add(JDOMElementLocator.parse(child));
        }
        if (_element.elements.isEmpty()) {
            _element.text = element.getValue();
        }
        return _element;
    }

    protected JDOMElementLocator(ELElement root) {
        super(root);
    }

    @Override
    protected void print(ELElement root, Document document, Map<String, String> namespaces) {
        if (root == null) {
            throw new NullPointerException("null root");
        }
        if (document == null) {
            throw new NullPointerException("null document");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaces");
        }
        this.print(root, namespaces, (Parent)document);
    }

    private void print(ELElement _element, Map<String, String> namespaces, Parent parent) {
        if (_element == null) {
            throw new NullPointerException("null _element");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaces");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        Element element = new Element(_element.localName, _element.namespaceURI);
        if (parent instanceof Document) {
            ((Document)parent).addContent((Content)element);
        } else {
            ((Element)parent).addContent((Content)element);
        }
        for (ELAttribute _attribute : _element.attributes.values()) {
            if (_attribute.namespaceURI.equals("")) {
                Attribute attribute = new Attribute(_attribute.localName, _attribute.value, Namespace.NO_NAMESPACE);
                element.setAttribute(attribute);
                continue;
            }
            Namespace namespace = Namespace.getNamespace((String)namespaces.get(_attribute.namespaceURI), (String)_attribute.namespaceURI);
            Attribute attribute = new Attribute(_attribute.localName, _attribute.value, namespace);
            element.setAttribute(attribute);
        }
        if (_element.elements.isEmpty()) {
            element.setText(_element.text);
        } else {
            for (ELElement grandchild : _element.elements) {
                this.print(grandchild, namespaces, (Parent)element);
            }
        }
    }
}

