/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.el;

import com.googlecode.jinahya.el.ELAttribute;
import com.googlecode.jinahya.el.ELElement;
import com.googlecode.jinahya.el.ELNode;
import com.googlecode.jinahya.el.ElementLocator;
import java.util.Map;
import org.kxml2.kdom.Document;
import org.kxml2.kdom.Element;
import org.kxml2.kdom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KDOMElementLocator
extends ElementLocator<Document> {
    public static ElementLocator<Document> newInstance(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element element = document.getRootElement();
        if (element == null) {
            throw new IllegalArgumentException("no root element");
        }
        return KDOMElementLocator.newInstance(element);
    }

    public static ElementLocator<Document> newInstance(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        return new KDOMElementLocator(KDOMElementLocator.parse(element));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespace();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getName();
        ELElement _element = new ELElement(namespaceURI, localName);
        int attributeCount = element.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespaceURI = element.getAttributeNamespace(i);
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = element.getAttributeName(i);
            String attributeValue = element.getAttributeValue(i);
            _element.attributes.put(ELNode.express(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        int childCount = element.getChildCount();
        String text = null;
        block5: for (int i = 0; i < childCount; ++i) {
            switch (element.getType(i)) {
                case 4: 
                case 5: {
                    if (text != null) continue block5;
                    text = element.getText(i);
                    continue block5;
                }
                case 2: {
                    _element.elements.add(KDOMElementLocator.parse((Element)element.getChild(i)));
                    continue block5;
                }
            }
        }
        if (_element.elements.isEmpty() && text != null) {
            _element.text = text;
        }
        return _element;
    }

    protected KDOMElementLocator(ELElement root) {
        super(root);
    }

    @Override
    protected void print(ELElement root, Document document, Map<String, String> namespaceMap) {
        if (root == null) {
            throw new NullPointerException("null root");
        }
        if (document == null) {
            throw new NullPointerException("null document");
        }
        if (namespaceMap == null) {
            throw new NullPointerException("null namespaces");
        }
        this.print(root, namespaceMap, (Node)document);
    }

    private void print(ELElement _element, Map<String, String> namesapces, Node parent) {
        if (_element == null) {
            throw new NullPointerException("null _element");
        }
        if (namesapces == null) {
            throw new NullPointerException("null namespaces");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        Element child = parent.createElement(_element.namespaceURI, _element.localName);
        parent.addChild(2, (Object)child);
        for (ELAttribute _attribute : _element.attributes.values()) {
            child.setAttribute(_attribute.namespaceURI, _attribute.localName, _attribute.value);
        }
        if (_element.text != null) {
            child.addChild(4, (Object)_element.text);
        } else {
            for (ELElement grandchild : _element.elements) {
                this.print(grandchild, namesapces, (Node)child);
            }
        }
    }
}

