/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.el;

import com.googlecode.jinahya.el.ELAttribute;
import com.googlecode.jinahya.el.ELElement;
import com.googlecode.jinahya.el.ELNode;
import com.googlecode.jinahya.el.ElementLocator;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMElementLocator
extends ElementLocator<Document> {
    public static ElementLocator<Document> newInstance(String namespaceURI, String localName) {
        return new XOMElementLocator(new ELElement(namespaceURI, localName));
    }

    public static ElementLocator<Document> newInstance(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element element = document.getRootElement();
        if (element == null) {
            throw new IllegalArgumentException("no root element");
        }
        return XOMElementLocator.newInstance(element);
    }

    public static ElementLocator<Document> newInstance(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        return new XOMElementLocator(XOMElementLocator.parse(element));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getLocalName();
        ELElement _element = new ELElement(namespaceURI, localName);
        int attributeCount = element.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            Attribute attribute = element.getAttribute(i);
            String attributeNamespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = attribute.getLocalName();
            String attributeValue = attribute.getValue();
            _element.attributes.put(ELNode.express(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        String text = null;
        int childCount = element.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Node child = element.getChild(i);
            if (child instanceof Text) {
                if (text != null) continue;
                text = element.getValue();
                continue;
            }
            if (!(child instanceof Element)) continue;
            _element.elements.add(XOMElementLocator.parse((Element)element.getChild(i)));
        }
        if (_element.elements.isEmpty() && text != null) {
            _element.text = text;
        }
        return _element;
    }

    protected XOMElementLocator(ELElement root) {
        super(root);
    }

    @Override
    protected void print(ELElement root, Document document, Map<String, String> namespaceMap) {
        if (root == null) {
            throw new NullPointerException("null root");
        }
        if (document == null) {
            throw new NullPointerException("null document");
        }
        if (namespaceMap == null) {
            throw new NullPointerException("null namespaces");
        }
        this.print(root, namespaceMap, (ParentNode)document);
    }

    private void print(ELElement _element, Map<String, String> namesapces, ParentNode parent) {
        if (_element == null) {
            throw new NullPointerException("null _element");
        }
        if (namesapces == null) {
            throw new NullPointerException("null namespaces");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        Element element = new Element(XOMElementLocator.getQualifiedName(_element, namesapces), _element.namespaceURI);
        if (parent instanceof Document) {
            Element previousRoot = ((Document)parent).getRootElement();
            parent.replaceChild((Node)previousRoot, (Node)element);
        } else {
            parent.appendChild((Node)element);
        }
        for (ELAttribute _attribute : _element.attributes.values()) {
            Attribute attribute = new Attribute(XOMElementLocator.getQualifiedName(_attribute, namesapces), _attribute.namespaceURI, _attribute.value);
            element.addAttribute(attribute);
        }
        if (_element.text != null) {
            element.appendChild(_element.text);
        } else {
            for (ELElement grandchild : _element.elements) {
                this.print(grandchild, namesapces, (ParentNode)element);
            }
        }
    }
}

