/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.elementlocator;

import com.googlecode.jinahya.elementlocator.ELAttribute;
import com.googlecode.jinahya.elementlocator.ELElement;
import com.googlecode.jinahya.elementlocator.ELNode;
import com.googlecode.jinahya.elementlocator.ElementLocator;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOM4JElementLocator
extends ElementLocator<Document> {
    public static ElementLocator<Document> newInstance(String namespaceURI, String localName) {
        return new DOM4JElementLocator(new ELElement(namespaceURI, localName));
    }

    public static ElementLocator<Document> parseInstance(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element rootElement = document.getRootElement();
        if (rootElement == null) {
            throw new IllegalArgumentException("no root element");
        }
        return new DOM4JElementLocator(DOM4JElementLocator.parse(rootElement));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getName();
        ELElement elelement = new ELElement(namespaceURI, localName);
        int attributeCount = element.attributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            Attribute attribute = element.attribute(i);
            String attributeNamespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = attribute.getName();
            String attributeValue = attribute.getValue();
            elelement.attributes.put(ELNode.express(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        String text = null;
        int nodeCount = element.nodeCount();
        block5: for (int i = 0; i < nodeCount; ++i) {
            Node node = element.node(i);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    if (text != null) continue block5;
                    text = node.getText();
                    continue block5;
                }
                case 1: {
                    elelement.elements.add(DOM4JElementLocator.parse((Element)node));
                    continue block5;
                }
            }
        }
        if (elelement.elements.isEmpty()) {
            elelement.text = text;
        }
        return elelement;
    }

    private static void print(ELElement elelement, Map<String, String> namesapces, Branch parent) {
        Document document;
        Element rootElement;
        if (elelement == null) {
            throw new NullPointerException("null elelement");
        }
        if (namesapces == null) {
            throw new NullPointerException("null namespaces");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        if (parent instanceof Document && (rootElement = (document = (Document)parent).getRootElement()) != null) {
            document.remove(rootElement);
        }
        Element element = parent.addElement(DOM4JElementLocator.getQualifiedName(elelement, namesapces), elelement.namespaceURI);
        for (ELAttribute elattribute : elelement.attributes.values()) {
            Namespace namespace = new Namespace(namesapces.get(elattribute.namespaceURI), elattribute.namespaceURI);
            QName qName = new QName(elattribute.localName, namespace, DOM4JElementLocator.getQualifiedName(elattribute, namesapces));
            element.addAttribute(qName, elattribute.value);
        }
        if (!elelement.elements.isEmpty()) {
            for (ELElement grandchild : elelement.elements) {
                DOM4JElementLocator.print(grandchild, namesapces, (Branch)element);
            }
            return;
        }
        if (elelement.text != null) {
            element.setText(elelement.text);
        }
    }

    private DOM4JElementLocator(ELElement root) {
        super(root);
    }

    public final Document toDocument() {
        return this.toDocument(DocumentHelper.createDocument());
    }

    @Override
    public Document toDocument(Document document) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        DOM4JElementLocator.print(this.getRoot(), this.getNamespaces(), (Branch)document);
        return document;
    }
}

