/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.elementlocator;

import com.googlecode.jinahya.elementlocator.ELAttribute;
import com.googlecode.jinahya.elementlocator.ELElement;
import com.googlecode.jinahya.elementlocator.ELNode;
import com.googlecode.jinahya.elementlocator.ElementLocator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMElementLocator
extends ElementLocator<Document> {
    public static ElementLocator<Document> newInstance(String namespaceURI, String localName) {
        return new DOMElementLocator(new ELElement(namespaceURI, localName));
    }

    public static ElementLocator<Document> parseInstance(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element documentElement = document.getDocumentElement();
        if (documentElement == null) {
            throw new IllegalArgumentException("no document element");
        }
        return new DOMElementLocator(DOMElementLocator.parse(documentElement));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getLocalName();
        ELElement elelement = new ELElement(namespaceURI, localName);
        NamedNodeMap attributes = element.getAttributes();
        int attributeLength = attributes.getLength();
        for (int i = 0; i < attributeLength; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String attributeNamespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = attribute.getLocalName();
            String attributeValue = attribute.getNodeValue();
            elelement.attributes.put(ELNode.express(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        String text = null;
        NodeList childNodes = element.getChildNodes();
        int length = childNodes.getLength();
        block5: for (int i = 0; i < length; ++i) {
            Node childNode = childNodes.item(i);
            switch (childNode.getNodeType()) {
                case 3: 
                case 4: {
                    if (text != null) continue block5;
                    text = childNode.getNodeValue();
                    continue block5;
                }
                case 1: {
                    elelement.elements.add(DOMElementLocator.parse((Element)childNode));
                    continue block5;
                }
            }
        }
        if (elelement.elements.isEmpty()) {
            elelement.text = text;
        }
        return elelement;
    }

    private static void print(ELElement elelement, Document document, Map<String, String> namesapces, Node parent) {
        if (elelement == null) {
            throw new NullPointerException("null elelement");
        }
        if (document == null) {
            throw new NullPointerException("null document");
        }
        if (namesapces == null) {
            throw new NullPointerException("null namespaces");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        Element element = document.createElementNS(elelement.namespaceURI, DOMElementLocator.getQualifiedName(elelement, namesapces));
        parent.appendChild(element);
        for (ELAttribute elattribute : elelement.attributes.values()) {
            element.setAttributeNS(elattribute.namespaceURI, DOMElementLocator.getQualifiedName(elattribute, namesapces), elattribute.value);
        }
        if (elelement.elements.isEmpty()) {
            if (elelement.text != null) {
                element.appendChild(document.createTextNode(elelement.text));
            }
            return;
        }
        for (ELElement grandchild : elelement.elements) {
            DOMElementLocator.print(grandchild, document, namesapces, element);
        }
    }

    private DOMElementLocator(ELElement root) {
        super(root);
    }

    @Override
    public Document toDocument(DocumentBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("null builder");
        }
        return this.toDocument(builder.newDocument());
    }

    @Override
    public Document toDocument(Document document) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        DOMElementLocator.print(this.getRoot(), document, this.getNamespaces(), document);
        return document;
    }
}

