/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.elementlocator;

import com.googlecode.jinahya.elementlocator.ELAttribute;
import com.googlecode.jinahya.elementlocator.ELElement;
import com.googlecode.jinahya.elementlocator.ELNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementLocator<D> {
    private final List<ELElement> path = new ArrayList<ELElement>();

    static String getQualifiedName(ELNode node, Map<String, String> namespaces) {
        if (node == null) {
            throw new NullPointerException("null node");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaceMap");
        }
        return ElementLocator.getQualifiedName(node.namespaceURI, node.localName, namespaces);
    }

    static String getQualifiedName(String namespaceURI, String localName, Map<String, String> namespaces) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaces");
        }
        if ("".equals(namespaceURI)) {
            return localName;
        }
        String namespacePrefix = namespaces.get(namespaceURI);
        if (namespacePrefix == null) {
            throw new RuntimeException("no namespace prefix for " + namespaceURI);
        }
        return namespacePrefix + ":" + localName;
    }

    ElementLocator(ELElement root) {
        if (root == null) {
            throw new NullPointerException("null root");
        }
        this.path.add(root);
    }

    public final int getChildCount(String localName) {
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        return this.getChildCount("", localName);
    }

    public final int getChildCount(String namespaceURI, String localName) {
        int count = 0;
        for (ELElement child : this.getCurrent().elements) {
            if (!child.localName.equals(localName) || !child.namespaceURI.equals(namespaceURI)) continue;
            ++count;
        }
        return count;
    }

    public final ElementLocator<D> locateRoot() {
        return this.root();
    }

    public final ElementLocator<D> root() {
        while (this.path.size() > 1) {
            this.path.remove(this.path.size() - 1);
        }
        return this;
    }

    public final ElementLocator<D> locateParent() {
        if (this.path.size() == 1) {
            throw new IllegalStateException("no parent to locate");
        }
        this.path.remove(this.path.size() - 1);
        return this;
    }

    public final ElementLocator<D> parent() {
        if (this.path.size() == 1) {
            throw new IllegalStateException("no parent to locate");
        }
        this.path.remove(this.path.size() - 1);
        return this;
    }

    public final ElementLocator<D> locateChild(String localName, int index) {
        return this.locateChild("", localName, index);
    }

    public final ElementLocator<D> locateChild(String namespaceURI, String localName, int index) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        if (index < 0) {
            throw new IllegalArgumentException("negative index: " + index);
        }
        int count = 0;
        for (ELElement element : this.getCurrent().elements) {
            if (!element.localName.equals(localName) || !element.namespaceURI.equals(namespaceURI) || count++ != index) continue;
            this.path.add(element);
            return this;
        }
        throw new IndexOutOfBoundsException("no child at " + index);
    }

    public final ElementLocator<D> child(String localName, int index) {
        return this.child("", localName, index);
    }

    public final ElementLocator<D> child(String namespaceURI, String localName, int index) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        if (index < 0) {
            throw new IllegalArgumentException("negative index: " + index);
        }
        int count = 0;
        for (ELElement element : this.getCurrent().elements) {
            if (!element.localName.equals(localName) || !element.namespaceURI.equals(namespaceURI) || count++ != index) continue;
            this.path.add(element);
            return this;
        }
        throw new IndexOutOfBoundsException("no child at " + index);
    }

    public final ElementLocator<D> addChild(String localName) {
        return this.addChild("", localName);
    }

    public final ElementLocator<D> addChild(String namespaceURI, String localName) {
        ELElement child = new ELElement(namespaceURI, localName);
        this.getCurrent().elements.add(child);
        this.path.add(child);
        return this;
    }

    public final ElementLocator<D> child(String localName) {
        return this.child("", localName);
    }

    public final ElementLocator<D> child(String namespaceURI, String localName) {
        ELElement child = new ELElement(namespaceURI, localName);
        this.getCurrent().elements.add(child);
        this.path.add(child);
        return this;
    }

    public final String getText() {
        return this.getCurrent().text;
    }

    public final String text() {
        return this.getCurrent().text;
    }

    public final ElementLocator<D> setText(String text) {
        this.getCurrent().text = text;
        return this;
    }

    public final ElementLocator<D> text(String text) {
        this.getCurrent().text = text;
        return this;
    }

    public final String getAttribute(String localName) {
        return this.getAttribute("", localName);
    }

    public final String getAttribute(String namespaceURI, String localName) {
        ELAttribute attribute = this.getCurrent().attributes.get(ELNode.express(namespaceURI, localName));
        if (attribute == null) {
            return null;
        }
        return attribute.value;
    }

    public final String attribute(String namespaceURI, String localName) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        ELAttribute attribute = this.getCurrent().attributes.get(ELNode.express(namespaceURI, localName));
        if (attribute == null) {
            return null;
        }
        return attribute.value;
    }

    public final ElementLocator<D> setAttribute(String localName, String value) {
        return this.setAttribute("", localName, value);
    }

    public final ElementLocator<D> setAttribute(String namespaceURI, String localName, String value) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        if (value == null) {
            throw new NullPointerException("null value");
        }
        ELAttribute attribute = new ELAttribute(namespaceURI, localName, value);
        this.getCurrent().attributes.put(ELNode.express(attribute), attribute);
        return this;
    }

    public final ElementLocator<D> attribute(String namespaceURI, String localName, String value) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        String expressed = ELNode.express(namespaceURI, localName);
        if (value == null) {
            this.getCurrent().attributes.remove(expressed);
            return this;
        }
        ELAttribute attribute = new ELAttribute(namespaceURI, localName, value);
        this.getCurrent().attributes.put(expressed, attribute);
        return this;
    }

    public final ElementLocator<D> removeAttribute(String localName) {
        return this.removeAttribute("", localName);
    }

    public final ElementLocator<D> removeAttribute(String namespaceURI, String localName) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        this.getCurrent().attributes.remove(ELNode.express(namespaceURI, localName));
        return this;
    }

    public abstract D toDocument(D var1);

    final Map<String, String> getNamespaces() {
        TreeMap<String, String> namespaces = new TreeMap<String, String>();
        ELElement root = this.path.get(0);
        for (String namespaceURI : root.getNamespaceURIs()) {
            namespaces.put(namespaceURI, null);
        }
        int index = 0;
        for (Map.Entry entry : namespaces.entrySet()) {
            entry.setValue("ns" + index++);
        }
        namespaces.put("http://www.w3.org/XML/1998/namespace", "xml");
        return namespaces;
    }

    public final ElementLocator<D> removeCurrent() {
        if (this.path.size() == 1) {
            throw new IllegalStateException("can't remove the root element");
        }
        ELElement element = this.getCurrent();
        this.locateParent().getCurrent().elements.remove(element);
        return this;
    }

    public final ElementLocator<D> remove() {
        if (this.path.size() == 1) {
            throw new IllegalStateException("can't remove the root element");
        }
        ELElement element = this.getCurrent();
        this.parent().getCurrent().elements.remove(element);
        return this;
    }

    final ELElement getCurrent() {
        return this.path.get(this.path.size() - 1);
    }

    final ELElement getRoot() {
        return this.path.get(0);
    }

    public final String toJSON() {
        return this.path.get(0).toJSON();
    }
}

