/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml;

abstract class ELNode {
    static final String NULL_NS_URI = "";
    static final String XML_NS_PREFIX = "xml";
    static final String XML_NS_URI = "http://www.w3.org/XML/1998/namespace";
    static final String XMLNS_ATTRIBUTE_NS_URI = "http://www.w3.org/2000/xmlns/";
    final String namespaceURI;
    final String localName;

    static String toJSONString(String string) {
        char[] chars;
        if (string == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\"");
        int length = string.length();
        for (int i = 0; i < length; i += chars.length) {
            int codePoint = string.codePointAt(i);
            chars = Character.toChars(codePoint);
            for (int j = 0; j < chars.length; ++j) {
                buffer.append("\\u");
                int high = chars[j] >> 8;
                if (high <= 15) {
                    buffer.append('0');
                }
                buffer.append(Integer.toHexString(high).toUpperCase());
                int low = chars[j] & 0xFF;
                if (low <= 15) {
                    buffer.append('0');
                }
                buffer.append(Integer.toHexString(low).toUpperCase());
            }
        }
        buffer.append("\"");
        return buffer.toString();
    }

    static String jamesClark(ELNode node) {
        if (node == null) {
            throw new NullPointerException("null node");
        }
        return ELNode.jamesClark(node.namespaceURI, node.localName);
    }

    static String jamesClark(String namespaceURI, String localName) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        return "{" + namespaceURI + "}" + localName;
    }

    public ELNode(String namespaceURI, String localName) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (XMLNS_ATTRIBUTE_NS_URI.equals(namespaceURI)) {
            throw new IllegalArgumentException("wrong namespaceURI: " + namespaceURI);
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        this.namespaceURI = namespaceURI;
        this.localName = localName;
    }

    public abstract String toJSON();
}

