/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml;

import com.googlecode.jinahya.xml.ELAttribute;
import com.googlecode.jinahya.xml.ELElement;
import com.googlecode.jinahya.xml.ELNode;
import com.googlecode.jinahya.xml.ElementLocator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOMElementLocator
extends ElementLocator<Document> {
    public static ElementLocator<Document> newInstance(String namespaceURI, String localName) {
        return new JDOMElementLocator(new ELElement(namespaceURI, localName));
    }

    public static ElementLocator<Document> parseInstance(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element rootElement = document.getRootElement();
        if (rootElement == null) {
            throw new IllegalArgumentException("no root element");
        }
        return new JDOMElementLocator(JDOMElementLocator.parse(rootElement));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getName();
        ELElement elelement = new ELElement(namespaceURI, localName);
        List attributes = element.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attribute = (Attribute)attributes.get(i);
            String attributeNamespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = attribute.getName();
            String attributeValue = attribute.getValue();
            elelement.attributes.put(ELNode.jamesClark(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        String text = null;
        for (Object child : element.getContent()) {
            if (child instanceof Text) {
                if (text != null) continue;
                text = ((Text)child).getText();
                continue;
            }
            if (!(child instanceof Element)) continue;
            elelement.elements.add(JDOMElementLocator.parse((Element)child));
        }
        if (elelement.elements.isEmpty()) {
            elelement.text = text;
        }
        return elelement;
    }

    private static void print(ELElement elelement, Map<String, String> namespaces, Parent parent) {
        if (elelement == null) {
            throw new NullPointerException("null elelement");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaces");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        Element element = new Element(elelement.localName, elelement.namespaceURI);
        if (parent instanceof Document) {
            Document document = (Document)parent;
            if (document.hasRootElement()) {
                document.removeContent((Content)document.getRootElement());
            }
            ((Document)parent).addContent((Content)element);
        } else {
            ((Element)parent).addContent((Content)element);
        }
        for (ELAttribute elattribute : elelement.attributes.values()) {
            if (elattribute.namespaceURI.equals("")) {
                Attribute attribute = new Attribute(elattribute.localName, elattribute.value, Namespace.NO_NAMESPACE);
                element.setAttribute(attribute);
                continue;
            }
            Namespace namespace = Namespace.getNamespace((String)namespaces.get(elattribute.namespaceURI), (String)elattribute.namespaceURI);
            Attribute attribute = new Attribute(elattribute.localName, elattribute.value, namespace);
            element.setAttribute(attribute);
        }
        if (!elelement.elements.isEmpty()) {
            for (ELElement grandchild : elelement.elements) {
                JDOMElementLocator.print(grandchild, namespaces, (Parent)element);
            }
            return;
        }
        if (elelement.text != null) {
            element.setText(elelement.text);
        }
    }

    private JDOMElementLocator(ELElement root) {
        super(root);
    }

    public final Document toDocument() {
        return this.toDocument(new Document());
    }

    @Override
    public Document toDocument(Document document) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        JDOMElementLocator.print(this.getRoot(), this.getNamespaces(), (Parent)document);
        return document;
    }
}

