/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml;

import com.googlecode.jinahya.xml.ELAttribute;
import com.googlecode.jinahya.xml.ELElement;
import com.googlecode.jinahya.xml.ELNode;
import com.googlecode.jinahya.xml.ElementLocator;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMElementLocator
extends ElementLocator<Document> {
    public static ElementLocator<Document> newInstance(String namespaceURI, String localName) {
        return new XOMElementLocator(new ELElement(namespaceURI, localName));
    }

    public static ElementLocator<Document> parseInstance(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element element = document.getRootElement();
        if (element == null) {
            throw new IllegalArgumentException("no root element");
        }
        return new XOMElementLocator(XOMElementLocator.parse(element));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getLocalName();
        ELElement elelement = new ELElement(namespaceURI, localName);
        int attributeCount = element.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            Attribute attribute = element.getAttribute(i);
            String attributeNamespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = attribute.getLocalName();
            String attributeValue = attribute.getValue();
            elelement.attributes.put(ELNode.jamesClark(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        String text = null;
        int childCount = element.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Node child = element.getChild(i);
            if (child instanceof Text) {
                if (text != null) continue;
                text = element.getValue();
                continue;
            }
            if (!(child instanceof Element)) continue;
            elelement.elements.add(XOMElementLocator.parse((Element)element.getChild(i)));
        }
        if (elelement.elements.isEmpty() && text != null) {
            elelement.text = text;
        }
        return elelement;
    }

    private static void print(ELElement elelement, Map<String, String> namesapces, ParentNode parent) {
        if (elelement == null) {
            throw new NullPointerException("null elelement");
        }
        if (namesapces == null) {
            throw new NullPointerException("null namespaces");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        Element element = new Element(XOMElementLocator.getQualifiedName(elelement, namesapces), elelement.namespaceURI);
        if (parent instanceof Document) {
            Element previousRoot = ((Document)parent).getRootElement();
            parent.replaceChild((Node)previousRoot, (Node)element);
        } else {
            parent.appendChild((Node)element);
        }
        for (ELAttribute elattribute : elelement.attributes.values()) {
            Attribute attribute = new Attribute(XOMElementLocator.getQualifiedName(elattribute, namesapces), elattribute.namespaceURI, elattribute.value);
            element.addAttribute(attribute);
        }
        if (elelement.elements.isEmpty()) {
            if (elelement.text != null) {
                element.appendChild(elelement.text);
            }
            return;
        }
        for (ELElement grandchild : elelement.elements) {
            XOMElementLocator.print(grandchild, namesapces, (ParentNode)element);
        }
    }

    private XOMElementLocator(ELElement root) {
        super(root);
    }

    public final Document toDocument() {
        return this.toDocument(new Document(new Element("tmp:tmp", "http://tmp")));
    }

    @Override
    public Document toDocument(Document document) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        XOMElementLocator.print(this.getRoot(), this.getNamespaces(), (ParentNode)document);
        return document;
    }
}

