/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml;

import com.googlecode.jinahya.xml.ELAttribute;
import com.googlecode.jinahya.xml.ELElement;
import com.googlecode.jinahya.xml.ELNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class ElementLocator {
    private final List path = new ArrayList();

    static String getQualifiedName(ELNode node, Map namespaces) {
        if (node == null) {
            throw new NullPointerException("null node");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaceMap");
        }
        return ElementLocator.getQualifiedName(node.namespaceURI, node.localName, namespaces);
    }

    static String getQualifiedName(String namespaceURI, String localName, Map namespaces) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaces");
        }
        if ("".equals(namespaceURI)) {
            return localName;
        }
        String namespacePrefix = (String)namespaces.get(namespaceURI);
        if (namespacePrefix == null) {
            throw new RuntimeException("no namespace prefix for " + namespaceURI);
        }
        return namespacePrefix + ":" + localName;
    }

    static Map getNamespaces(ELElement element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        TreeMap<Object, String> namespaces = new TreeMap<Object, String>();
        Set namespaceURIs = element.getNamespaceURIs();
        Iterator i = namespaceURIs.iterator();
        while (i.hasNext()) {
            namespaces.put(i.next(), null);
        }
        int index = 0;
        Iterator i2 = namespaceURIs.iterator();
        while (i2.hasNext()) {
            namespaces.put(i2.next(), "ns" + index);
            ++index;
        }
        namespaces.put("http://www.w3.org/XML/1998/namespace", "xml");
        return namespaces;
    }

    public ElementLocator(ELElement root) {
        if (root == null) {
            throw new NullPointerException("null root");
        }
        this.path.add(root);
    }

    public final String getNamespaceURI() {
        return this.getCurrent().namespaceURI;
    }

    public final String getLocalName() {
        return this.getCurrent().localName;
    }

    public final int getChildCount(String localName) {
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        return this.getChildCount("", localName);
    }

    public final int getChildCount(String namespaceURI, String localName) {
        int count = 0;
        Iterator i = this.getCurrent().elements.iterator();
        while (i.hasNext()) {
            ELElement child = (ELElement)i.next();
            if (!child.localName.equals(localName) || !child.namespaceURI.equals(namespaceURI)) continue;
            ++count;
        }
        return count;
    }

    public final ElementLocator locateRoot() {
        while (this.path.size() > 1) {
            this.path.remove(this.path.size() - 1);
        }
        return this;
    }

    public final ElementLocator locateParent() {
        if (this.path.size() == 1) {
            throw new IllegalStateException("no parent to locate");
        }
        this.path.remove(this.path.size() - 1);
        return this;
    }

    public final ElementLocator locateChild(String localName, int index) {
        return this.locateChild("", localName, index);
    }

    public final ElementLocator locateChild(String namespaceURI, String localName, int index) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        if (index < 0) {
            throw new IllegalArgumentException("negative index: " + index);
        }
        int count = 0;
        Iterator i = this.getCurrent().elements.iterator();
        while (i.hasNext()) {
            ELElement element = (ELElement)i.next();
            if (!element.localName.equals(localName) || !element.namespaceURI.equals(namespaceURI)) continue;
            if (count == index) {
                this.path.add(element);
                return this;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException("no child at " + index);
    }

    public final ElementLocator addChild(String localName) {
        return this.addChild("", localName);
    }

    public final ElementLocator addChild(String namespaceURI, String localName) {
        ELElement child = new ELElement(namespaceURI, localName);
        this.getCurrent().elements.add(child);
        this.path.add(child);
        return this;
    }

    public final String getText() {
        return this.getCurrent().text;
    }

    public final ElementLocator setText(String text) {
        this.getCurrent().text = text;
        return this;
    }

    public final String getAttribute(String localName) {
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        return this.getAttribute("", localName);
    }

    public final String getAttribute(String namespaceURI, String localName) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        ELAttribute attribute = (ELAttribute)this.getCurrent().attributes.get(ELNode.jamesClark(namespaceURI, localName));
        if (attribute == null) {
            return null;
        }
        return attribute.value;
    }

    public final ElementLocator setAttribute(String localName, String value) {
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        return this.setAttribute("", localName, value);
    }

    public final ElementLocator setAttribute(String namespaceURI, String localName, String value) {
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        if (localName == null) {
            throw new NullPointerException("null localName");
        }
        if (localName.trim().isEmpty()) {
            throw new IllegalArgumentException("empty localName");
        }
        String expressed = ELNode.jamesClark(namespaceURI, localName);
        if (value == null) {
            this.getCurrent().attributes.remove(expressed);
            return this;
        }
        ELAttribute attribute = new ELAttribute(namespaceURI, localName, value);
        this.getCurrent().attributes.put(expressed, attribute);
        return this;
    }

    public final ElementLocator removeCurrent() {
        if (this.path.size() == 1) {
            throw new IllegalStateException("can't remove the root element");
        }
        ELElement element = this.getCurrent();
        this.locateParent().getCurrent().elements.remove(element);
        return this;
    }

    final ELElement getCurrent() {
        return (ELElement)this.path.get(this.path.size() - 1);
    }

    public final ELElement getRoot() {
        return (ELElement)this.path.get(0);
    }
}

