/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml;

import com.googlecode.jinahya.xml.ELAttribute;
import com.googlecode.jinahya.xml.ELElement;
import com.googlecode.jinahya.xml.ELNode;
import com.googlecode.jinahya.xml.ElementLocator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;

public class JDOMElementLocator
extends ElementLocator {
    public static ElementLocator parse(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element rootElement = document.getRootElement();
        if (rootElement == null) {
            throw new IllegalArgumentException("no root element");
        }
        return new JDOMElementLocator(JDOMElementLocator.parse(rootElement));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getName();
        ELElement elelement = new ELElement(namespaceURI, localName);
        List attributes = element.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attribute = (Attribute)attributes.get(i);
            String attributeNamespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = attribute.getName();
            String attributeValue = attribute.getValue();
            elelement.attributes.put(ELNode.jamesClark(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        String text = null;
        Iterator i = element.getContent().iterator();
        while (i.hasNext()) {
            Object child = i.next();
            if (child instanceof Text) {
                if (text != null) continue;
                text = ((Text)child).getText();
                continue;
            }
            if (!(child instanceof Element)) continue;
            elelement.elements.add(JDOMElementLocator.parse((Element)child));
        }
        if (elelement.elements.isEmpty()) {
            elelement.text = text;
        }
        return elelement;
    }

    public static Document print(ELElement element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        Document document = new Document();
        JDOMElementLocator.print(element, document);
        return document;
    }

    public static void print(ELElement element, Document document) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        if (document == null) {
            throw new NullPointerException("null document");
        }
        JDOMElementLocator.print(element, (Parent)document, ElementLocator.getNamespaces(element));
    }

    private static void print(ELElement child, Parent parent, Map namespaces) {
        if (child == null) {
            throw new NullPointerException("null child");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaces");
        }
        Element element = new Element(child.localName, child.namespaceURI);
        if (parent instanceof Document) {
            Document document = (Document)parent;
            if (document.hasRootElement()) {
                document.removeContent((Content)document.getRootElement());
            }
            ((Document)parent).addContent((Content)element);
        } else {
            ((Element)parent).addContent((Content)element);
        }
        Iterator<Object> i = child.attributes.values().iterator();
        while (i.hasNext()) {
            ELAttribute elattribute = (ELAttribute)i.next();
            if (elattribute.namespaceURI.equals("")) {
                Attribute attribute = new Attribute(elattribute.localName, elattribute.value, Namespace.NO_NAMESPACE);
                element.setAttribute(attribute);
                continue;
            }
            Namespace namespace = Namespace.getNamespace((String)((String)namespaces.get(elattribute.namespaceURI)), (String)elattribute.namespaceURI);
            Attribute attribute = new Attribute(elattribute.localName, elattribute.value, namespace);
            element.setAttribute(attribute);
        }
        if (!child.elements.isEmpty()) {
            i = child.elements.iterator();
            while (i.hasNext()) {
                JDOMElementLocator.print((ELElement)i.next(), (Parent)element, namespaces);
            }
            return;
        }
        if (child.text != null) {
            element.setText(child.text);
        }
    }

    public JDOMElementLocator(ELElement root) {
        super(root);
    }
}

