/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml;

import com.googlecode.jinahya.xml.ELAttribute;
import com.googlecode.jinahya.xml.ELElement;
import com.googlecode.jinahya.xml.ELNode;
import com.googlecode.jinahya.xml.ElementLocator;
import java.util.Iterator;
import java.util.Map;
import org.kxml2.kdom.Document;
import org.kxml2.kdom.Element;
import org.kxml2.kdom.Node;

public class KDOMElementLocator
extends ElementLocator {
    public static ElementLocator parse(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element rootElement = document.getRootElement();
        if (rootElement == null) {
            throw new IllegalArgumentException("no root element");
        }
        return new KDOMElementLocator(KDOMElementLocator.parse(rootElement));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespace();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getName();
        ELElement elelement = new ELElement(namespaceURI, localName);
        int attributeCount = element.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespaceURI = element.getAttributeNamespace(i);
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = element.getAttributeName(i);
            String attributeValue = element.getAttributeValue(i);
            elelement.attributes.put(ELNode.jamesClark(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        String text = null;
        int childCount = element.getChildCount();
        block5: for (int i = 0; i < childCount; ++i) {
            switch (element.getType(i)) {
                case 4: 
                case 5: {
                    if (text != null) continue block5;
                    text = element.getText(i);
                    continue block5;
                }
                case 2: {
                    elelement.elements.add(KDOMElementLocator.parse((Element)element.getChild(i)));
                    continue block5;
                }
            }
        }
        if (elelement.elements.isEmpty()) {
            elelement.text = text;
        }
        return elelement;
    }

    public static Document print(ELElement element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        Document document = new Document();
        KDOMElementLocator.print(element, document);
        return document;
    }

    public static void print(ELElement element, Document document) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        if (document == null) {
            throw new NullPointerException("null document");
        }
        KDOMElementLocator.print(element, (Node)document, ElementLocator.getNamespaces(element));
    }

    private static void print(ELElement child, Node parent, Map namesapces) {
        if (child == null) {
            throw new NullPointerException("null child");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        if (namesapces == null) {
            throw new NullPointerException("null namespaces");
        }
        int childCount = parent.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            parent.removeChild(i);
        }
        Element element = parent.createElement(child.namespaceURI, child.localName);
        parent.addChild(2, (Object)element);
        Iterator<Object> i = child.attributes.values().iterator();
        while (i.hasNext()) {
            ELAttribute attribute = (ELAttribute)i.next();
            element.setAttribute(attribute.namespaceURI, attribute.localName, attribute.value);
        }
        if (!child.elements.isEmpty()) {
            i = child.elements.iterator();
            while (i.hasNext()) {
                KDOMElementLocator.print((ELElement)i.next(), (Node)element, namesapces);
            }
            return;
        }
        if (child.text != null) {
            element.addChild(4, (Object)child.text);
        }
    }

    public KDOMElementLocator(ELElement root) {
        super(root);
    }
}

