/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml;

import com.googlecode.jinahya.xml.ELAttribute;
import com.googlecode.jinahya.xml.ELElement;
import com.googlecode.jinahya.xml.ELNode;
import com.googlecode.jinahya.xml.ElementLocator;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class DOM4JElementLocator
extends ElementLocator {
    public static ElementLocator parse(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element rootElement = document.getRootElement();
        if (rootElement == null) {
            throw new IllegalArgumentException("no root element");
        }
        return new DOM4JElementLocator(DOM4JElementLocator.parse(rootElement));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getName();
        ELElement elelement = new ELElement(namespaceURI, localName);
        int attributeCount = element.attributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            Attribute attribute = element.attribute(i);
            String attributeNamespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = attribute.getName();
            String attributeValue = attribute.getValue();
            elelement.getAttributes().put(ELNode.jamesClark(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        String text = null;
        int nodeCount = element.nodeCount();
        block5: for (int i = 0; i < nodeCount; ++i) {
            Node node = element.node(i);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    if (text != null) continue block5;
                    text = node.getText();
                    continue block5;
                }
                case 1: {
                    elelement.getElements().add(DOM4JElementLocator.parse((Element)node));
                    continue block5;
                }
            }
        }
        if (elelement.getElements().isEmpty()) {
            elelement.setText(text);
        }
        return elelement;
    }

    public static Document print(ElementLocator locator) {
        if (locator == null) {
            throw new NullPointerException("null locator");
        }
        Document document = DocumentHelper.createDocument();
        DOM4JElementLocator.print(locator, document);
        return document;
    }

    public static void print(ElementLocator locator, Document document) {
        if (locator == null) {
            throw new NullPointerException("null locator");
        }
        if (document == null) {
            throw new NullPointerException("null document");
        }
        ELElement element = locator.getRoot();
        DOM4JElementLocator.print(element, (Branch)document, ElementLocator.getNamespaces(element));
    }

    private static void print(ELElement child, Branch parent, Map namesapces) {
        Document document;
        Element rootElement;
        if (child == null) {
            throw new NullPointerException("null child");
        }
        if (namesapces == null) {
            throw new NullPointerException("null namespaces");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        if (parent instanceof Document && (rootElement = (document = (Document)parent).getRootElement()) != null) {
            document.remove(rootElement);
        }
        Element element = parent.addElement(ElementLocator.getQualifiedName(child, namesapces), child.getNamespaceURI());
        Iterator<Object> i = child.getAttributes().values().iterator();
        while (i.hasNext()) {
            ELAttribute elattribute = (ELAttribute)i.next();
            Namespace namespace = new Namespace((String)namesapces.get(elattribute.getNamespaceURI()), elattribute.getNamespaceURI());
            QName qName = new QName(elattribute.getLocalName(), namespace, ElementLocator.getQualifiedName(elattribute, namesapces));
            element.addAttribute(qName, elattribute.getValue());
        }
        if (!child.getElements().isEmpty()) {
            i = child.getElements().iterator();
            while (i.hasNext()) {
                DOM4JElementLocator.print((ELElement)i.next(), (Branch)element, namesapces);
            }
            return;
        }
        String text = child.getText();
        if (text != null) {
            element.setText(text);
        }
    }

    public DOM4JElementLocator(ELElement root) {
        super(root);
    }
}

