/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml;

import com.googlecode.jinahya.xml.ELAttribute;
import com.googlecode.jinahya.xml.ELElement;
import com.googlecode.jinahya.xml.ELNode;
import com.googlecode.jinahya.xml.ElementLocator;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMElementLocator
extends ElementLocator {
    public static ElementLocator parse(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element documentElement = document.getDocumentElement();
        if (documentElement == null) {
            throw new IllegalArgumentException("no document element");
        }
        return new DOMElementLocator(DOMElementLocator.parse(documentElement));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getLocalName();
        ELElement elelement = new ELElement(namespaceURI, localName);
        NamedNodeMap attributes = element.getAttributes();
        int attributeLength = attributes.getLength();
        for (int i = 0; i < attributeLength; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String attributeNamespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = attribute.getLocalName();
            String attributeValue = attribute.getNodeValue();
            elelement.getAttributes().put(ELNode.jamesClark(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        String text = null;
        NodeList childNodes = element.getChildNodes();
        int length = childNodes.getLength();
        block5: for (int i = 0; i < length; ++i) {
            Node childNode = childNodes.item(i);
            switch (childNode.getNodeType()) {
                case 3: 
                case 4: {
                    if (text != null) continue block5;
                    text = childNode.getNodeValue();
                    continue block5;
                }
                case 1: {
                    elelement.getElements().add(DOMElementLocator.parse((Element)childNode));
                    continue block5;
                }
            }
        }
        if (elelement.getElements().isEmpty()) {
            elelement.setText(text);
        }
        return elelement;
    }

    public static void print(ElementLocator locator, Document document) {
        if (locator == null) {
            throw new NullPointerException("null locator");
        }
        if (document == null) {
            throw new NullPointerException("null document");
        }
        ELElement root = locator.getRoot();
        DOMElementLocator.print(root, document, ElementLocator.getNamespaces(root), document);
    }

    private static void print(ELElement child, Node parent, Map namesapces, Document document) {
        Element documentElement;
        if (child == null) {
            throw new NullPointerException("null child");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        if (namesapces == null) {
            throw new NullPointerException("null namespaces");
        }
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element element = document.createElementNS(child.getNamespaceURI(), ElementLocator.getQualifiedName(child, namesapces));
        if (parent instanceof Document && (documentElement = ((Document)parent).getDocumentElement()) != null) {
            parent.removeChild(documentElement);
        }
        parent.appendChild(element);
        Iterator<Object> i = child.getAttributes().values().iterator();
        while (i.hasNext()) {
            ELAttribute elattribute = (ELAttribute)i.next();
            element.setAttributeNS(elattribute.getNamespaceURI(), ElementLocator.getQualifiedName(elattribute, namesapces), elattribute.getValue());
        }
        if (!child.getElements().isEmpty()) {
            i = child.getElements().iterator();
            while (i.hasNext()) {
                DOMElementLocator.print((ELElement)i.next(), element, namesapces, document);
            }
            return;
        }
        if (child.getText() != null) {
            element.appendChild(document.createTextNode(child.getText()));
        }
    }

    public DOMElementLocator(ELElement root) {
        super(root);
    }
}

