/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml;

import com.googlecode.jinahya.xml.ELAttribute;
import com.googlecode.jinahya.xml.ELElement;
import com.googlecode.jinahya.xml.ELNode;
import com.googlecode.jinahya.xml.ElementLocator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;

public class JDOMElementLocator
extends ElementLocator {
    public static ElementLocator parse(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element rootElement = document.getRootElement();
        if (rootElement == null) {
            throw new IllegalArgumentException("no root element");
        }
        return new JDOMElementLocator(JDOMElementLocator.parse(rootElement));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getName();
        ELElement elelement = new ELElement(namespaceURI, localName);
        List attributes = element.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attribute = (Attribute)attributes.get(i);
            String attributeNamespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = attribute.getName();
            String attributeValue = attribute.getValue();
            elelement.getAttributes().put(ELNode.jamesClark(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        String text = null;
        Iterator i = element.getContent().iterator();
        while (i.hasNext()) {
            Object child = i.next();
            if (child instanceof Text) {
                if (text != null) continue;
                text = ((Text)child).getText();
                continue;
            }
            if (!(child instanceof Element)) continue;
            elelement.getElements().add(JDOMElementLocator.parse((Element)child));
        }
        if (elelement.getElements().isEmpty()) {
            elelement.setText(text);
        }
        return elelement;
    }

    public static Document print(ElementLocator locator) {
        if (locator == null) {
            throw new NullPointerException("null locator");
        }
        Document document = new Document();
        JDOMElementLocator.print(locator, document);
        return document;
    }

    public static void print(ElementLocator locator, Document document) {
        if (locator == null) {
            throw new NullPointerException("null locator");
        }
        if (document == null) {
            throw new NullPointerException("null document");
        }
        ELElement root = locator.getRoot();
        JDOMElementLocator.print(root, (Parent)document, ElementLocator.getNamespaces(root));
    }

    private static void print(ELElement child, Parent parent, Map namespaces) {
        if (child == null) {
            throw new NullPointerException("null child");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaces");
        }
        Element element = new Element(child.getLocalName(), child.getNamespaceURI());
        if (parent instanceof Document) {
            Document document = (Document)parent;
            if (document.hasRootElement()) {
                document.removeContent((Content)document.getRootElement());
            }
            ((Document)parent).addContent((Content)element);
        } else {
            ((Element)parent).addContent((Content)element);
        }
        Iterator<Object> i = child.getAttributes().values().iterator();
        while (i.hasNext()) {
            ELAttribute elattribute = (ELAttribute)i.next();
            if (elattribute.getNamespaceURI().equals("")) {
                Attribute attribute = new Attribute(elattribute.getLocalName(), elattribute.getValue(), Namespace.NO_NAMESPACE);
                element.setAttribute(attribute);
                continue;
            }
            Namespace namespace = Namespace.getNamespace((String)((String)namespaces.get(elattribute.getNamespaceURI())), (String)elattribute.getNamespaceURI());
            Attribute attribute = new Attribute(elattribute.getLocalName(), elattribute.getValue(), namespace);
            element.setAttribute(attribute);
        }
        if (!child.getElements().isEmpty()) {
            i = child.getElements().iterator();
            while (i.hasNext()) {
                JDOMElementLocator.print((ELElement)i.next(), (Parent)element, namespaces);
            }
            return;
        }
        if (child.getText() != null) {
            element.setText(child.getText());
        }
    }

    public JDOMElementLocator(ELElement root) {
        super(root);
    }
}

