/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml;

import com.googlecode.jinahya.xml.ELAttribute;
import com.googlecode.jinahya.xml.ELElement;
import com.googlecode.jinahya.xml.ElementLocator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StAXElementLocator
extends ElementLocator {
    public static ElementLocator parse(XMLStreamReader reader) throws XMLStreamException {
        if (reader == null) {
            throw new NullPointerException("null reader");
        }
        reader.require(7, null, null);
        reader.nextTag();
        reader.require(1, null, null);
        String namespaceURI = reader.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = reader.getLocalName();
        ELElement root = new ELElement(namespaceURI, localName);
        StAXElementLocator locator = new StAXElementLocator(root);
        StAXElementLocator.parse(reader, locator);
        reader.require(2, null, null);
        reader.next();
        reader.require(8, null, null);
        return locator;
    }

    private static void parse(XMLStreamReader reader, ElementLocator locator) throws XMLStreamException {
        String localName;
        String namespaceURI;
        if (reader == null) {
            throw new NullPointerException("null reader");
        }
        if (locator == null) {
            throw new NullPointerException("null locator");
        }
        reader.require(1, null, null);
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            namespaceURI = reader.getAttributeNamespace(i);
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            localName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            locator.setAttribute(namespaceURI, localName, value);
        }
        String text = null;
        while (reader.next() != 2) {
            switch (reader.getEventType()) {
                case 4: 
                case 12: {
                    if (text != null) break;
                    text = reader.getText();
                    break;
                }
                case 1: {
                    namespaceURI = reader.getNamespaceURI();
                    if (namespaceURI == null) {
                        namespaceURI = "";
                    }
                    localName = reader.getLocalName();
                    locator.addChild(namespaceURI, localName);
                    StAXElementLocator.parse(reader, locator);
                    locator.locateParent();
                    break;
                }
            }
        }
        ELElement current = locator.getCurrent();
        if (current.getElements().isEmpty()) {
            current.setText(text);
        }
    }

    public static void print(ElementLocator locator, XMLStreamWriter writer) throws XMLStreamException {
        if (locator == null) {
            throw new NullPointerException("null locator");
        }
        if (writer == null) {
            throw new NullPointerException("null writer");
        }
        StAXElementLocator.print(locator, writer, "UTF-8", "1.0");
    }

    public static void print(ElementLocator locator, XMLStreamWriter writer, String encoding, String version) throws XMLStreamException {
        if (locator == null) {
            throw new NullPointerException("null locator");
        }
        if (writer == null) {
            throw new NullPointerException("null writer");
        }
        if (encoding == null) {
            throw new NullPointerException("null encoding");
        }
        if (version == null) {
            throw new NullPointerException("null version");
        }
        writer.writeStartDocument(encoding, version);
        ELElement element = locator.getRoot();
        StAXElementLocator.print(element, writer, ElementLocator.getNamespaces(element), true);
        writer.writeEndDocument();
    }

    private static void print(ELElement element, XMLStreamWriter writer, Map namespaces) throws XMLStreamException {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        if (writer == null) {
            throw new NullPointerException("null writer");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaces");
        }
        StAXElementLocator.print(element, writer, namespaces, false);
    }

    private static void print(ELElement element, XMLStreamWriter writer, Map namespaces, boolean writeNamespace) throws XMLStreamException {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        if (writer == null) {
            throw new NullPointerException("null writer");
        }
        if (namespaces == null) {
            throw new NullPointerException("null namespaces");
        }
        String elementNamespaceURI = element.getNamespaceURI();
        if (elementNamespaceURI.equals("")) {
            writer.writeStartElement(element.getLocalName());
        } else {
            writer.writeStartElement((String)namespaces.get(elementNamespaceURI), element.getLocalName(), elementNamespaceURI);
        }
        if (writeNamespace) {
            Iterator i = namespaces.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String namespaceURI = (String)entry.getKey();
                if (namespaceURI.equals("")) continue;
                String namespacePrefix = (String)entry.getValue();
                writer.writeNamespace(namespacePrefix, namespaceURI);
            }
        }
        Map attributes = element.getAttributes();
        Iterator i = attributes.values().iterator();
        while (i.hasNext()) {
            ELAttribute attribute = (ELAttribute)i.next();
            String attributeNamespaceURI = attribute.getNamespaceURI();
            if (attributeNamespaceURI.equals("")) {
                writer.writeAttribute(attribute.getLocalName(), attribute.getValue());
                continue;
            }
            writer.writeAttribute((String)namespaces.get(attributeNamespaceURI), attributeNamespaceURI, attribute.getLocalName(), attribute.getValue());
        }
        List children = element.getElements();
        if (!children.isEmpty()) {
            Iterator i2 = children.iterator();
            while (i2.hasNext()) {
                ELElement child = (ELElement)i2.next();
                StAXElementLocator.print(child, writer, namespaces);
            }
        } else if (element.getText() != null) {
            writer.writeCharacters(element.getText());
        }
        writer.writeEndElement();
    }

    public StAXElementLocator(ELElement root) {
        super(root);
    }
}

