/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml;

import com.googlecode.jinahya.xml.ELAttribute;
import com.googlecode.jinahya.xml.ELElement;
import com.googlecode.jinahya.xml.ELNode;
import com.googlecode.jinahya.xml.ElementLocator;
import java.util.Iterator;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;

public class XOMElementLocator
extends ElementLocator {
    public static ElementLocator parse(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element element = document.getRootElement();
        if (element == null) {
            throw new IllegalArgumentException("no root element");
        }
        return new XOMElementLocator(XOMElementLocator.parse(element));
    }

    private static ELElement parse(Element element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String localName = element.getLocalName();
        ELElement elelement = new ELElement(namespaceURI, localName);
        int attributeCount = element.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            Attribute attribute = element.getAttribute(i);
            String attributeNamespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNamespaceURI)) continue;
            if (attributeNamespaceURI == null) {
                attributeNamespaceURI = "";
            }
            String attributeLocalName = attribute.getLocalName();
            String attributeValue = attribute.getValue();
            elelement.getAttributes().put(ELNode.jamesClark(attributeNamespaceURI, attributeLocalName), new ELAttribute(attributeNamespaceURI, attributeLocalName, attributeValue));
        }
        String text = null;
        int childCount = element.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Node child = element.getChild(i);
            if (child instanceof Text) {
                if (text != null) continue;
                text = element.getValue();
                continue;
            }
            if (!(child instanceof Element)) continue;
            elelement.getElements().add(XOMElementLocator.parse((Element)element.getChild(i)));
        }
        if (elelement.getElements().isEmpty()) {
            elelement.setText(text);
        }
        return elelement;
    }

    public static Document print(ELElement element) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        Document document = new Document(new Element("ignore:me", "http://ignore.me"));
        XOMElementLocator.print(element, document);
        return document;
    }

    public static void print(ELElement child, Document document) {
        if (child == null) {
            throw new NullPointerException("null child");
        }
        if (document == null) {
            throw new NullPointerException("null document");
        }
        XOMElementLocator.print(child, (ParentNode)document, ElementLocator.getNamespaces(child));
    }

    private static void print(ELElement child, ParentNode parent, Map namesapces) {
        if (child == null) {
            throw new NullPointerException("null child");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        if (namesapces == null) {
            throw new NullPointerException("null namespaces");
        }
        Element element = new Element(ElementLocator.getQualifiedName(child, namesapces), child.getNamespaceURI());
        if (parent instanceof Document) {
            Element previousRoot = ((Document)parent).getRootElement();
            parent.replaceChild((Node)previousRoot, (Node)element);
        } else {
            parent.appendChild((Node)element);
        }
        Iterator<Object> i = child.getAttributes().values().iterator();
        while (i.hasNext()) {
            ELAttribute elattribute = (ELAttribute)i.next();
            Attribute attribute = new Attribute(ElementLocator.getQualifiedName(elattribute, namesapces), elattribute.getNamespaceURI(), elattribute.getValue());
            element.addAttribute(attribute);
        }
        if (!child.getElements().isEmpty()) {
            i = child.getElements().iterator();
            while (i.hasNext()) {
                XOMElementLocator.print((ELElement)i.next(), (ParentNode)element, namesapces);
            }
            return;
        }
        if (child.getText() != null) {
            element.appendChild(child.getText());
        }
    }

    public XOMElementLocator(ELElement root) {
        super(root);
    }
}

