/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.DependencyResolver;
import com.googlecode.jinahya.util.DependencyResolverException;
import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.State;
import com.googlecode.jinahya.util.fsm.Task;
import com.googlecode.jinahya.util.fsm.TaskContext;
import com.googlecode.jinahya.util.fsm.Transition;
import com.googlecode.jinahya.util.fsm.TransitionContext;
import java.util.List;
import java.util.Map;

public class Machine {
    private volatile boolean started = false;
    private volatile boolean finished = false;
    private volatile State state = State.UNKNOWN;
    private final TaskContext taskContext;

    public Machine(TaskContext taskContext) {
        if (taskContext == null) {
            throw new NullPointerException("null taskContext");
        }
        this.taskContext = taskContext;
    }

    public final synchronized State getState() {
        return this.state;
    }

    public final synchronized void setState(State state) throws FSMException {
        if (state == null) {
            throw new NullPointerException("null state");
        }
        if (this.state.equals(state)) {
            throw new IllegalStateException("same state");
        }
        if (this.isFinished()) {
            throw new IllegalStateException("already finished");
        }
        State source = this.state;
        State target = this.state = state;
        final Transition transition = new Transition(source, target);
        if (!this.isStarted()) {
            if (!this.isStarting(transition)) {
                throw new IllegalStateException("not started yet");
            }
            this.started = true;
        }
        if (this.isFinishing(transition)) {
            this.finished = true;
        }
        Map<String, Task> tasks = this.taskContext.getTasks();
        final DependencyResolver resolver = new DependencyResolver();
        for (String taskId : tasks.keySet()) {
            try {
                resolver.add((Object)taskId, (Object[])new String[]{null});
            }
            catch (DependencyResolverException dre) {
                dre.printStackTrace(System.err);
            }
        }
        final StringBuffer taskIdBuffer = new StringBuffer();
        TransitionContext transitionContext = new TransitionContext(){

            public Transition getTransition() {
                return transition;
            }

            public final void setPerformBefore(String nextTaskId) throws FSMException {
                if (nextTaskId == null) {
                    throw new NullPointerException("null nextTaskId");
                }
                String taskId = taskIdBuffer.toString();
                if (taskId.isEmpty()) {
                    return;
                }
                try {
                    resolver.add((Object)nextTaskId, (Object[])new String[]{taskId});
                }
                catch (DependencyResolverException dre) {
                    throw new FSMException(dre);
                }
            }

            public final void setPerformAfter(String previousTaskId) throws FSMException {
                if (previousTaskId == null) {
                    throw new NullPointerException("null previousTaskId");
                }
                String taskId = taskIdBuffer.toString();
                if (taskId.isEmpty()) {
                    return;
                }
                try {
                    resolver.add((Object)taskId, (Object[])new String[]{previousTaskId});
                }
                catch (DependencyResolverException dre) {
                    throw new FSMException(dre);
                }
            }
        };
        for (Map.Entry<String, Task> entry : tasks.entrySet()) {
            taskIdBuffer.delete(0, taskIdBuffer.length());
            taskIdBuffer.append(entry.getKey());
            entry.getValue().prepare(transitionContext);
        }
        taskIdBuffer.delete(0, taskIdBuffer.length());
        for (List idGroup : resolver.getVerticalGroups()) {
            Task[] taskGroup = new Task[idGroup.size()];
            for (int i = 0; i < taskGroup.length; ++i) {
                taskGroup[i] = tasks.get(idGroup.get(i));
            }
            this.perform(transitionContext, taskGroup);
        }
    }

    protected void perform(TransitionContext context, Task ... tasks) throws FSMException {
        for (Task task : tasks) {
            task.perform(context);
        }
    }

    public final synchronized boolean isStarted() {
        return this.started;
    }

    public final synchronized boolean isFinished() {
        return this.finished;
    }

    protected boolean isStarting(Transition transition) {
        return true;
    }

    protected boolean isAllowed(Transition transition) {
        return true;
    }

    protected boolean isFinishing(Transition transition) {
        return false;
    }
}

