/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.DependencyResolver;
import com.googlecode.jinahya.util.DependencyResolverException;
import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.State;
import com.googlecode.jinahya.util.fsm.Task;
import com.googlecode.jinahya.util.fsm.Transition;
import com.googlecode.jinahya.util.fsm.TransitionContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Machine {
    private final Map<String, Task> tasks;
    private volatile boolean started = false;
    private volatile boolean finished = false;
    private volatile State state = State.UNKNOWN;

    public Machine(Map<String, Task> tasks) {
        if (tasks == null) {
            throw new NullPointerException("null tasks");
        }
        this.tasks = tasks;
    }

    public final synchronized State getState() {
        return this.state;
    }

    public final synchronized void setState(State state) throws FSMException {
        if (state == null) {
            throw new NullPointerException("null state");
        }
        if (this.state.equals(state)) {
            throw new IllegalStateException("same state");
        }
        if (this.isFinished()) {
            throw new IllegalStateException("already finished");
        }
        State source = this.state;
        State target = this.state = state;
        final Transition transition = new Transition(source, target);
        if (!this.isStarted()) {
            if (!this.isStarting(transition)) {
                throw new IllegalStateException("not started yet");
            }
            this.started = true;
        }
        if (this.isFinishing(transition)) {
            this.finished = true;
        }
        final DependencyResolver resolver = new DependencyResolver();
        final StringBuffer idBuffer = new StringBuffer();
        TransitionContext transitionContext = new TransitionContext(){

            public Transition getTransition() {
                return transition;
            }

            public final void setPerformBefore(String nextTaskId) throws FSMException {
                if (nextTaskId == null) {
                    throw new NullPointerException("null nextTaskId");
                }
                String taskId = idBuffer.toString();
                if (taskId.isEmpty()) {
                    return;
                }
                try {
                    resolver.add((Object)nextTaskId, (Object[])new String[]{taskId});
                }
                catch (DependencyResolverException dre) {
                    throw new FSMException(dre);
                }
            }

            public final void setPerformAfter(String previousTaskId) throws FSMException {
                if (previousTaskId == null) {
                    throw new NullPointerException("null previousTaskId");
                }
                String taskId = idBuffer.toString();
                if (taskId.isEmpty()) {
                    return;
                }
                try {
                    resolver.add((Object)taskId, (Object[])new String[]{previousTaskId});
                }
                catch (DependencyResolverException dre) {
                    throw new FSMException(dre);
                }
            }
        };
        for (Map.Entry<String, Task> entry : this.tasks.entrySet()) {
            if (!entry.getValue().matches(transition)) continue;
            try {
                resolver.add((Object)entry.getKey(), (Object[])new String[]{null});
            }
            catch (DependencyResolverException dre) {
                throw new FSMException(dre);
            }
            idBuffer.delete(0, idBuffer.length());
            idBuffer.append(entry.getKey());
            entry.getValue().prepare(transitionContext);
        }
        idBuffer.delete(0, idBuffer.length());
        for (List idGroup : resolver.getVerticalGroups()) {
            Task[] taskGroup = new Task[idGroup.size()];
            for (int i = 0; i < taskGroup.length; ++i) {
                taskGroup[i] = this.tasks.get(idGroup.get(i));
            }
            this.perform(transitionContext, taskGroup);
        }
    }

    protected void perform(TransitionContext context, Task ... tasks) throws FSMException {
        for (Task task : tasks) {
            task.perform(context);
        }
    }

    public final synchronized boolean isStarted() {
        return this.started;
    }

    public final synchronized boolean isFinished() {
        return this.finished;
    }

    protected abstract boolean isStarting(Transition var1);

    protected abstract boolean isAllowed(Transition var1);

    protected abstract boolean isFinishing(Transition var1);
}

