/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.Task;
import com.googlecode.jinahya.util.fsm.Transition;
import com.googlecode.jinahya.util.fsm.TransitionMatcher;

public abstract class SwitchTask
extends Task {
    private final TransitionMatcher[] offMatchers;
    private volatile boolean on = false;

    public SwitchTask(String id, TransitionMatcher[] onMatchers, TransitionMatcher[] offMatchers) {
        super(id, onMatchers);
        if (offMatchers == null) {
            throw new NullPointerException("null offMatchers");
        }
        if (offMatchers.length == 0) {
            throw new NullPointerException("empty offMatchers");
        }
        this.offMatchers = offMatchers;
    }

    public boolean matches(Transition transition) {
        boolean matches;
        if (this.on) {
            matches = transition.matchesAny(this.offMatchers);
            if (matches) {
                this.on = false;
            }
        } else {
            matches = super.matches(transition);
            if (matches) {
                this.on = true;
            }
        }
        return matches;
    }

    protected final boolean isOn() {
        return this.on;
    }
}

