/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.Transition;
import com.googlecode.jinahya.util.fsm.TransitionContext;
import com.googlecode.jinahya.util.fsm.TransitionMatcher;

public abstract class Task {
    private final String id;
    private final TransitionMatcher[] matchers;

    public Task(String id, TransitionMatcher ... matchers) {
        if (id == null) {
            throw new NullPointerException("null id");
        }
        if (matchers == null) {
            throw new NullPointerException("null matchers");
        }
        if (matchers.length == 0) {
            throw new IllegalArgumentException("empty matchers");
        }
        this.id = id;
        this.matchers = matchers;
    }

    public final String getId() {
        return this.id;
    }

    public boolean matches(Transition transition) {
        if (transition == null) {
            throw new NullPointerException("null transition");
        }
        return transition.matchesAny(this.matchers);
    }

    public abstract void prepare(TransitionContext var1) throws FSMException;

    public abstract void perform(TransitionContext var1) throws FSMException;
}

