/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.ResourceLoader;
import com.googlecode.jinahya.util.fsm.Task;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskContext {
    private static final String TASK_INDEX_FILENAME = "com.googlecode.jinahya.util.fsm.task.index";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Task> load(String contextPath, ResourceLoader resourceLoader, ClassLoader classLoader) throws FSMException, IOException, ClassNotFoundException {
        if (contextPath == null) {
            throw new NullPointerException("null contextPath");
        }
        if (resourceLoader == null) {
            throw new NullPointerException("null resourceLoader");
        }
        if (classLoader == null) {
            throw new NullPointerException("null classLoader");
        }
        HashSet<String> packageNames = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(contextPath, ":");
        while (tokenizer.hasMoreTokens()) {
            String packageName = tokenizer.nextToken();
            if (packageName.trim().length() <= 0) continue;
            packageNames.add(packageName);
        }
        HashSet<String> classNames = new HashSet<String>();
        for (String packageName : packageNames) {
            String resourceName = packageName.replace('.', '/') + "/" + TASK_INDEX_FILENAME;
            InputStream resource = resourceLoader.loadResource(resourceName);
            if (resource == null) {
                throw new FSMException("null resource loaded");
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(resource, "UTF-8"));
                try {
                    String className = null;
                    while ((className = reader.readLine()) != null) {
                        if ((className = className.trim()).length() == 0 || className.startsWith("#")) continue;
                        classNames.add(packageName + "." + className);
                    }
                }
                finally {
                    reader.close();
                }
            }
            finally {
                resource.close();
            }
        }
        HashMap<String, Task> tasks = new HashMap<String, Task>();
        for (String className : classNames) {
            Class<?> loaded = classLoader.loadClass(className);
            if (!Task.class.isAssignableFrom(loaded)) {
                throw new FSMException("loaded class(" + loaded + ") is not assignable to " + Task.class);
            }
            try {
                Constructor<?> constructor = loaded.getConstructor(null);
                try {
                    Task task = (Task)constructor.newInstance(null);
                    String taskId = task.getId();
                    if (tasks.containsKey(taskId)) {
                        throw new FSMException("duplicate task id: " + taskId);
                    }
                    tasks.put(taskId, task);
                }
                catch (InstantiationException ie) {
                    throw new FSMException("failed to create a new instance: " + loaded, ie);
                }
                catch (IllegalAccessException iae) {
                    throw new FSMException("failed to create a new instance: " + loaded, iae);
                }
                catch (InvocationTargetException ite) {
                    throw new FSMException("failed to create a new instance: " + loaded, ite);
                }
            }
            catch (NoSuchMethodException nsme) {
                throw new FSMException("no default constructor: " + loaded, nsme);
            }
        }
        return tasks;
    }

    private TaskContext() {
    }
}

