/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.AbstractTask;
import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.Transition;
import com.googlecode.jinahya.util.fsm.TransitionContext;
import com.googlecode.jinahya.util.fsm.TransitionMatcher;

public abstract class SwitchTask
extends AbstractTask {
    private final TransitionMatcher[] offMatchers;
    private volatile boolean on = false;

    public SwitchTask(String id, TransitionMatcher[] onMatchers, TransitionMatcher[] offMatchers) {
        super(id, onMatchers);
        if (offMatchers == null) {
            throw new NullPointerException("null offMatchers");
        }
        if (offMatchers.length == 0) {
            throw new NullPointerException("empty offMatchers");
        }
        this.offMatchers = offMatchers;
    }

    public boolean matches(Transition transition) {
        if (this.on) {
            boolean matches = transition.matchesAny(this.offMatchers);
            if (matches) {
                this.on = false;
            }
            return matches;
        }
        boolean matches = super.matches(transition);
        if (matches) {
            this.on = true;
        }
        return matches;
    }

    public void prepare(TransitionContext context) throws FSMException {
        if (this.on) {
            this.prepareOff(context);
        } else {
            this.prepareOn(context);
        }
    }

    protected abstract void prepareOn(TransitionContext var1) throws FSMException;

    protected abstract void prepareOff(TransitionContext var1) throws FSMException;

    public void perform(TransitionContext context) throws FSMException {
        if (this.on) {
            this.performOff(context);
        } else {
            this.performOn(context);
        }
    }

    protected abstract void performOn(TransitionContext var1) throws FSMException;

    protected abstract void performOff(TransitionContext var1) throws FSMException;
}

