/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.DependencyResolver;
import com.googlecode.jinahya.util.DependencyResolverException;
import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.Transition;
import com.googlecode.jinahya.util.fsm.TransitionContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TransitionContextFactory {
    static TransitionContext newInstance(final Transition transition, final StringBuffer buffer, final DependencyResolver<String> resolver) {
        final Map properties = Collections.synchronizedMap(new HashMap());
        return new TransitionContext(){

            public Transition getTransition() {
                return transition;
            }

            public void setPerformBefore(String nextTaskId) throws FSMException {
                if (nextTaskId == null) {
                    throw new NullPointerException("null nextTaskId");
                }
                String taskId = buffer.toString();
                if (taskId.isEmpty()) {
                    return;
                }
                try {
                    resolver.add((Object)nextTaskId, (Object[])new String[]{taskId});
                }
                catch (DependencyResolverException dre) {
                    throw new FSMException(dre);
                }
            }

            public void setPerformAfter(String previousTaskId) throws FSMException {
                if (previousTaskId == null) {
                    throw new NullPointerException("null previousTaskId");
                }
                String taskId = buffer.toString();
                if (taskId.isEmpty()) {
                    return;
                }
                try {
                    resolver.add((Object)taskId, (Object[])new String[]{previousTaskId});
                }
                catch (DependencyResolverException dre) {
                    throw new FSMException(dre);
                }
            }

            public Object getProperty(String name) {
                if (name == null) {
                    throw new NullPointerException("null name");
                }
                return properties.get(name);
            }

            public Object setProperty(String name, Object value) {
                if (name == null) {
                    throw new NullPointerException("null name");
                }
                return properties.put(name, value);
            }
        };
    }

    private TransitionContextFactory() {
    }
}

