/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.DependencyResolver;
import com.googlecode.jinahya.util.DependencyResolverException;
import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.State;
import com.googlecode.jinahya.util.fsm.Task;
import com.googlecode.jinahya.util.fsm.TaskContext;
import com.googlecode.jinahya.util.fsm.Transition;
import com.googlecode.jinahya.util.fsm.TransitionContext;
import com.googlecode.jinahya.util.fsm.TransitionContextFactory;
import com.googlecode.jinahya.util.fsm.TransitionEvent;
import com.googlecode.jinahya.util.fsm.TransitionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Machine {
    public static final String PROPERTY_NAME_STATE = "state";
    private final TaskContext taskContext;
    private transient Map<String, Task> tasks;
    private volatile boolean started = false;
    private volatile boolean finished = false;
    private volatile State state = State.UNKNOWN;
    private Map<String, Object> properties = Collections.synchronizedMap(new HashMap());
    private List<TransitionListener> listeners = new ArrayList<TransitionListener>();
    private final PropertyChangeSupport pcs;

    public Machine(TaskContext taskContext) {
        if (taskContext == null) {
            throw new NullPointerException("null taskContext");
        }
        this.taskContext = taskContext;
        this.pcs = new PropertyChangeSupport(this);
    }

    public final synchronized State getState() {
        return this.state;
    }

    public final synchronized void setState(State state) throws FSMException {
        if (state == null) {
            throw new NullPointerException("null state");
        }
        if (this.state.equals(state)) {
            throw new FSMException("same state");
        }
        if (this.isFinished()) {
            throw new FSMException("already finished");
        }
        State source = this.state;
        State target = this.state = state;
        this.pcs.firePropertyChange(PROPERTY_NAME_STATE, source, target);
        Transition transition = new Transition(this, source, target);
        if (!this.isStarted()) {
            if (!this.isStarting(transition)) {
                throw new IllegalStateException("not started yet");
            }
            this.started = true;
        }
        if (this.isFinishing(transition)) {
            this.finished = true;
        }
        TransitionEvent event = new TransitionEvent(transition);
        for (TransitionListener listener : this.listeners) {
            listener.transited(event);
        }
        StringBuffer buffer = new StringBuffer();
        DependencyResolver resolver = new DependencyResolver();
        TransitionContext context = TransitionContextFactory.newInstance(transition, buffer, (DependencyResolver<String>)resolver);
        if (this.tasks == null) {
            this.tasks = this.taskContext.getTasks();
        }
        for (Map.Entry<String, Task> entry : this.tasks.entrySet()) {
            if (!entry.getValue().matches(transition)) continue;
            try {
                resolver.add((Object)entry.getKey(), (Object[])new String[]{null});
            }
            catch (DependencyResolverException dre) {
                throw new FSMException(dre);
            }
            buffer.delete(0, buffer.length());
            buffer.append(entry.getKey());
            entry.getValue().prepare(context);
        }
        buffer.delete(0, buffer.length());
        for (List idGroup : resolver.getVerticalGroups()) {
            Task[] taskGroup = new Task[idGroup.size()];
            for (int i = 0; i < taskGroup.length; ++i) {
                taskGroup[i] = this.tasks.get(idGroup.get(i));
            }
            this.perform(context, taskGroup);
        }
    }

    protected void perform(TransitionContext context, Task ... tasks) throws FSMException {
        for (Task task : tasks) {
            task.perform(context);
        }
    }

    public final synchronized boolean isStarted() {
        return this.started;
    }

    public final synchronized boolean isFinished() {
        return this.finished;
    }

    public final Object getProperty(String name) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        return this.properties.get(name);
    }

    public final Object setProperty(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        return this.properties.put(name, value);
    }

    protected abstract boolean isStarting(Transition var1);

    protected abstract boolean isAllowed(Transition var1);

    protected abstract boolean isFinishing(Transition var1);

    public void addTransitionListener(TransitionListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        this.listeners.add(listener);
    }

    public void removeTransitionListener(TransitionListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        this.listeners.remove(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        this.pcs.removePropertyChangeListener(listener);
    }
}

