/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.Machine;
import com.googlecode.jinahya.util.fsm.State;
import com.googlecode.jinahya.util.fsm.TransitionMatcher;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transition {
    private final Machine machine;
    private final State source;
    private final State target;

    public Transition(Machine machine, State source, State target) {
        if (machine == null) {
            throw new NullPointerException("null machine");
        }
        if (source == null) {
            throw new NullPointerException("null source");
        }
        if (target == null) {
            throw new NullPointerException("null target");
        }
        if (source.equals(target)) {
            throw new IllegalArgumentException("source is equlas to target");
        }
        this.machine = machine;
        this.source = source;
        this.target = target;
    }

    public final Machine getMachine() {
        return this.machine;
    }

    public final State getSource() {
        return this.source;
    }

    public final State getTarget() {
        return this.target;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Transition)) {
            return false;
        }
        Transition transition = (Transition)obj;
        if (!this.machine.equals(transition.getMachine())) {
            return false;
        }
        if (!this.source.equals(transition.getSource())) {
            return false;
        }
        return this.target.equals(transition.getTarget());
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.machine.hashCode();
        hashCode = 37 * hashCode + this.source.hashCode();
        hashCode = 37 * hashCode + this.target.hashCode();
        return hashCode;
    }

    public String toString() {
        return "Transition(" + this.machine + ":" + this.source + "->" + this.target + ")";
    }

    public final boolean matchesAny(TransitionMatcher ... matchers) {
        if (matchers == null) {
            throw new NullPointerException("null matchers");
        }
        return this.matchesAny(Arrays.asList(matchers));
    }

    public final boolean matchesAny(List<TransitionMatcher> matchers) {
        if (matchers == null) {
            throw new NullPointerException("null matchers");
        }
        if (matchers.isEmpty()) {
            throw new NullPointerException("empty matchers");
        }
        for (TransitionMatcher matcher : matchers) {
            if (!matcher.matches(this)) continue;
            return true;
        }
        return false;
    }

    public final boolean matchesAll(TransitionMatcher ... matchers) {
        if (matchers == null) {
            throw new NullPointerException("null matchers");
        }
        return this.matchesAll(Arrays.asList(matchers));
    }

    public final boolean matchesAll(List<TransitionMatcher> matchers) {
        if (matchers == null) {
            throw new NullPointerException("null matchers");
        }
        if (matchers.isEmpty()) {
            throw new NullPointerException("empty matchers");
        }
        for (TransitionMatcher matcher : matchers) {
            if (matcher.matches(this)) continue;
            return false;
        }
        return true;
    }
}

