/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;

public class ClassResourceLoader
implements ResourceLoader {
    private final ClassLoader classLoader;

    public ClassResourceLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("null classLoader");
        }
        this.classLoader = classLoader;
    }

    public InputStream loadResource(String name) throws IOException, FSMException {
        if (name == null) {
            throw new NullPointerException("null resourceName");
        }
        InputStream resource = this.classLoader.getResourceAsStream(name);
        if (resource == null) {
            throw new FSMException("failed to load resource: " + name);
        }
        return resource;
    }
}

