/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.fsm;

import com.googlecode.jinahya.fsm.State;
import com.googlecode.jinahya.fsm.TransitionMatcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transition {
    private final State source;
    private final State target;
    private final Map<String, Object> properties = Collections.synchronizedMap(new HashMap());

    public Transition(State source, State target) {
        if (source == null) {
            throw new NullPointerException("null source");
        }
        if (target == null) {
            throw new NullPointerException("null target");
        }
        if (source.equals(target)) {
            throw new IllegalArgumentException("source is equlas to target");
        }
        this.source = source;
        this.target = target;
    }

    public final State getSource() {
        return this.source;
    }

    public final State getTarget() {
        return this.target;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Transition)) {
            return false;
        }
        Transition casted = (Transition)obj;
        if (!this.source.equals(casted.getSource())) {
            return false;
        }
        return this.target.equals(casted.getTarget());
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.source.hashCode();
        hashCode = 37 * hashCode + this.target.hashCode();
        return hashCode;
    }

    public String toString() {
        return super.toString() + "?source=(" + this.source + ")&target=(" + this.target + ")";
    }

    public final boolean matchesAny(TransitionMatcher[] matchers) {
        if (matchers == null) {
            throw new NullPointerException("null matchers");
        }
        return this.matchesAny(Arrays.asList(matchers));
    }

    public final boolean matchesAny(List<TransitionMatcher> matchers) {
        if (matchers == null) {
            throw new NullPointerException("null matchers");
        }
        for (TransitionMatcher matcher : matchers) {
            if (!matcher.matches(this)) continue;
            return true;
        }
        return false;
    }

    public final boolean matchesAll(TransitionMatcher[] matchers) {
        if (matchers == null) {
            throw new NullPointerException("null matchers");
        }
        return this.matchesAll(Arrays.asList(matchers));
    }

    public final boolean matchesAll(List<TransitionMatcher> matchers) {
        if (matchers == null) {
            throw new NullPointerException("null matchers");
        }
        for (TransitionMatcher matcher : matchers) {
            if (matcher.matches(this)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getProperty(String name) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        Map<String, Object> map = this.properties;
        synchronized (map) {
            return this.properties.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object setProperty(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        Map<String, Object> map = this.properties;
        synchronized (map) {
            return this.properties.put(name, value);
        }
    }
}

