/*
 * Copyright 2011 <a href="mailto:jinahya@gmail.com">Jin Kwon</a>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.googlecode.jinahya.fsm;


import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;


/**
 * A ResourceLoader implementation using File I/O.
 *
 * @author <a href="mailto:jinahya@gmail.com">Jin Kwon</a>
 */
public class FileResourceLoader implements ResourceLoader {


    @Override
    public InputStream loadResource(final String name)
        throws IOException, FSMException {

        if (name == null) {
            throw new NullPointerException("null resourceName");
        }

        return new FileInputStream(name);
    }
}
