/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.fsm;

import com.googlecode.jinahya.fsm.AbstractTask;
import com.googlecode.jinahya.fsm.Transition;
import com.googlecode.jinahya.fsm.TransitionMatcher;

public abstract class SwitchTask
extends AbstractTask {
    private final TransitionMatcher[] offMatchers;
    private volatile boolean on = false;

    public SwitchTask(TransitionMatcher[] onMatchers, TransitionMatcher ... offMatchers) {
        super(onMatchers);
        if (offMatchers == null) {
            throw new NullPointerException("null offMatchers");
        }
        if (offMatchers.length == 0) {
            throw new NullPointerException("empty offMatchers");
        }
        this.offMatchers = offMatchers;
    }

    public boolean matches(Transition transition) {
        if (this.on) {
            return transition.matchesAny(this.offMatchers);
        }
        return super.matches(transition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Transition transition) {
        if (this.on) {
            try {
                this.performOff(transition);
            }
            finally {
                this.on = false;
            }
        }
        try {
            this.performOn(transition);
        }
        finally {
            this.on = true;
        }
    }

    protected abstract void performOn(Transition var1);

    protected abstract void performOff(Transition var1);
}

