/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.fsm;

import com.googlecode.jinahya.fsm.FSMException;
import com.googlecode.jinahya.fsm.ResourceLoader;
import com.googlecode.jinahya.fsm.Task;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;

public final class TaskLoader {
    private static final String TASK_INDEX_FILENAME = "com.googlecode.jinahya.fsm.task.index";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task[] loadTasks(String contextPath, ResourceLoader resourceLoader, ClassLoader classLoader) throws FSMException {
        if (contextPath == null) {
            throw new NullPointerException("null contextPath");
        }
        if (resourceLoader == null) {
            throw new NullPointerException("null resourceLoader");
        }
        if (classLoader == null) {
            throw new NullPointerException("null classLoader");
        }
        HashSet<String> packageNames = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(contextPath, ":");
        while (tokenizer.hasMoreTokens()) {
            String packageName = tokenizer.nextToken();
            if ((packageName = packageName.trim()).length() == 0) continue;
            packageNames.add(packageName);
        }
        HashSet<String> classNames = new HashSet<String>();
        for (String packageName : packageNames) {
            String resourceName = packageName.replace('.', '/') + "/" + TASK_INDEX_FILENAME;
            try {
                InputStream resource = resourceLoader.loadResource(resourceName);
                if (resource == null) {
                    throw new FSMException("no index file for package(" + packageName + ")");
                }
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resource, "UTF-8"));
                    try {
                        String className = null;
                        while ((className = reader.readLine()) != null) {
                            if ((className = className.trim()).length() == 0 || className.startsWith("#")) continue;
                            classNames.add(packageName + "." + className);
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                finally {
                    resource.close();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        ArrayList taskClasses = new ArrayList(classNames.size());
        for (String className : classNames) {
            try {
                Class<?> loaded = classLoader.loadClass(className);
                if (!Task.class.isAssignableFrom(loaded)) {
                    throw new FSMException("loaded class(" + loaded + ") is not assignable to " + Task.class);
                }
                if (taskClasses.contains(loaded)) continue;
                taskClasses.add(loaded);
            }
            catch (ClassNotFoundException cnfe) {
                throw new FSMException("failed to load a class: " + className, cnfe);
            }
        }
        Task[] tasks = new Task[taskClasses.size()];
        for (int i = 0; i < tasks.length; ++i) {
            Class taskClass = (Class)taskClasses.get(i);
            try {
                Constructor constructor = ((Class)taskClasses.get(i)).getConstructor(null);
                try {
                    tasks[i] = (Task)constructor.newInstance(null);
                    continue;
                }
                catch (InstantiationException ie) {
                    throw new FSMException("failed to create a new instance of " + taskClass, ie);
                }
                catch (IllegalAccessException iae) {
                    throw new FSMException("failed to create a new instance of " + taskClass, iae);
                }
                catch (InvocationTargetException ite) {
                    throw new FSMException("failed to create a new instance of " + taskClass, ite);
                }
            }
            catch (NoSuchMethodException nsme) {
                throw new FSMException("no default constructor: " + taskClass, nsme);
            }
        }
        return tasks;
    }

    private TaskLoader() {
    }
}

