/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.fsm;

import com.googlecode.jinahya.fsm.State;

public abstract class AbstractState
implements State {
    private static final long serialVersionUID = 1617832714763742755L;
    private final int code;
    private final String name;

    public AbstractState(int code, String name) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("empty name");
        }
        this.code = code;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof State)) {
            return false;
        }
        State casted = (State)obj;
        if (this.code != casted.code()) {
            return false;
        }
        return this.name.equals(casted.name());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.code;
        result = 37 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return super.toString() + "?code=" + this.code + "&name=" + this.name;
    }

    public final int code() {
        return this.code;
    }

    public final String name() {
        return this.name;
    }
}

