/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.fsm;

import com.googlecode.jinahya.fsm.FSMException;
import com.googlecode.jinahya.fsm.State;
import com.googlecode.jinahya.fsm.Task;
import com.googlecode.jinahya.fsm.Transition;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Machine {
    private final transient List<Task> tasks;
    private volatile boolean started = false;
    private volatile boolean finished = false;
    private volatile State state = State.UNKNOWN;

    public Machine(List<Task> tasks) {
        if (tasks == null) {
            throw new NullPointerException("null tasks");
        }
        this.tasks = Collections.unmodifiableList(tasks);
    }

    public final synchronized State getState() {
        return this.state;
    }

    public final synchronized void setState(State state) throws FSMException {
        if (state == null) {
            throw new NullPointerException("null state");
        }
        if (this.state.equals(state)) {
            throw new FSMException("same state");
        }
        if (this.finished) {
            throw new FSMException("already finished");
        }
        Transition transition = new Transition(this.state, state);
        if (!this.isAllowed(transition)) {
            throw new FSMException("not allowed: " + transition);
        }
        if (!this.started) {
            if (this.isStarting(transition)) {
                this.started = true;
            } else {
                throw new FSMException("not started yet");
            }
        }
        for (Task task : this.tasks) {
            task.perform(transition);
        }
        if (this.isFinishing(transition)) {
            this.finished = true;
        }
        this.state = state;
    }

    protected abstract boolean isStarting(Transition var1);

    protected abstract boolean isAllowed(Transition var1);

    protected abstract boolean isFinishing(Transition var1);
}

