/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.fsm;

import com.googlecode.jinahya.fsm.FSMException;
import com.googlecode.jinahya.fsm.ResourceLoader;
import com.googlecode.jinahya.fsm.Task;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskLoader {
    private static final String TASK_INDEX_FILENAME = "com.googlecode.jinahya.fsm.task.index";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Task> loadTasks(String contextPath, ResourceLoader resourceLoader, ClassLoader classLoader) throws FSMException {
        if (contextPath == null) {
            throw new NullPointerException("null contextPath");
        }
        if (resourceLoader == null) {
            throw new NullPointerException("null resourceLoader");
        }
        if (classLoader == null) {
            throw new NullPointerException("null classLoader");
        }
        HashSet<String> packageNames = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(contextPath, ":");
        while (tokenizer.hasMoreTokens()) {
            String packageName = tokenizer.nextToken();
            if ((packageName = packageName.trim()).length() == 0) continue;
            packageNames.add(packageName);
        }
        HashSet<String> classNames = new HashSet<String>();
        for (String packageName : packageNames) {
            String resourceName = packageName.replace('.', '/') + "/" + TASK_INDEX_FILENAME;
            try {
                InputStream inputStream = resourceLoader.loadResource(resourceName);
                if (inputStream == null) {
                    throw new FSMException("no index file for package(" + packageName + ")");
                }
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    try {
                        String className = null;
                        while ((className = reader.readLine()) != null) {
                            if ((className = className.trim()).length() == 0 || className.startsWith("#")) continue;
                            classNames.add(packageName + "." + className);
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        ArrayList taskClasses = new ArrayList(classNames.size());
        for (String className : classNames) {
            try {
                Class<?> clazz = classLoader.loadClass(className);
                if (!Task.class.isAssignableFrom(clazz)) {
                    throw new FSMException("loaded class(" + clazz + ") is not assignable to " + Task.class);
                }
                if (taskClasses.contains(clazz)) continue;
                taskClasses.add(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new FSMException("failed to load a class: " + className, classNotFoundException);
            }
        }
        ArrayList<Task> tasks = new ArrayList<Task>(taskClasses.size());
        for (Class clazz : taskClasses) {
            try {
                Constructor constructor = clazz.getConstructor(null);
                try {
                    tasks.add((Task)constructor.newInstance(null));
                }
                catch (InstantiationException ie) {
                    throw new FSMException("failed to create a new instance of " + clazz, ie);
                }
                catch (IllegalAccessException iae) {
                    throw new FSMException("failed to create a new instance of " + clazz, iae);
                }
                catch (InvocationTargetException ite) {
                    throw new FSMException("failed to create a new instance of " + clazz, ite);
                }
            }
            catch (NoSuchMethodException nsme) {
                throw new FSMException("no default constructor: " + clazz, nsme);
            }
        }
        return tasks;
    }

    private TaskLoader() {
    }
}

