/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.DependencyResolver;
import com.googlecode.jinahya.util.DependencyResolverException;
import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.Task;
import com.googlecode.jinahya.util.fsm.TaskContext;
import com.googlecode.jinahya.util.fsm.Transition;
import com.googlecode.jinahya.util.fsm.TransitionContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MachineContext {
    protected final TaskContext taskContext;

    protected MachineContext(TaskContext taskContext) {
        if (taskContext == null) {
            throw new NullPointerException("null taskContext");
        }
        this.taskContext = taskContext;
    }

    public void transited(final Transition transition) throws FSMException {
        final Map properties = Collections.synchronizedMap(new HashMap());
        final ThreadLocal<String> taskIdLocal = new ThreadLocal<String>();
        final DependencyResolver resolver = new DependencyResolver();
        TransitionContext transitionContext = new TransitionContext(){

            public Transition getTransition() {
                return transition;
            }

            public void setPerformBefore(String nextTaskId) throws FSMException {
                if (nextTaskId == null) {
                    throw new NullPointerException("null nextTaskId");
                }
                String taskId = (String)taskIdLocal.get();
                if (taskId == null) {
                    throw new IllegalStateException("no task id set");
                }
                try {
                    resolver.addDependency((Object)nextTaskId, (Object)taskId);
                }
                catch (DependencyResolverException dre) {
                    throw new FSMException(dre);
                }
            }

            public void setPerformAfter(String previousTaskId) throws FSMException {
                if (previousTaskId == null) {
                    throw new NullPointerException("null previousTaskId");
                }
                String taskId = (String)taskIdLocal.get();
                if (taskId == null) {
                    throw new IllegalStateException("no task id set");
                }
                try {
                    resolver.addDependency((Object)taskId, (Object)previousTaskId);
                }
                catch (DependencyResolverException dre) {
                    throw new FSMException(dre);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void setProperty(String taskId, String name, Object value) {
                if (taskId == null) {
                    throw new NullPointerException("null taskId");
                }
                if (name == null) {
                    throw new NullPointerException("null name");
                }
                Map map = properties;
                synchronized (map) {
                    HashMap<String, Object> map2 = (HashMap<String, Object>)properties.get(taskId);
                    if (map2 == null) {
                        map2 = new HashMap<String, Object>();
                        properties.put(taskId, map2);
                    }
                    map2.put(name, value);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getProperty(String taskId, String name) {
                if (taskId == null) {
                    throw new NullPointerException("null taskId");
                }
                if (name == null) {
                    throw new NullPointerException("null name");
                }
                Map map = properties;
                synchronized (map) {
                    Map map2 = (Map)properties.get(taskId);
                    if (map2 == null) {
                        return null;
                    }
                    return map2.get(name);
                }
            }

            public void setProperty(Task owner, String name, Object value) {
                if (owner == null) {
                    throw new NullPointerException("null owner");
                }
                if (name == null) {
                    throw new NullPointerException("null name");
                }
                this.setProperty(owner.getId(), name, value);
            }

            public Object getProprety(Task owner, String name) {
                if (owner == null) {
                    throw new NullPointerException("null owner");
                }
                if (name == null) {
                    throw new NullPointerException("null name");
                }
                return this.getProperty(owner.getId(), name);
            }

            public Object getProprety(String name, String ownerId) {
                if (name == null) {
                    throw new NullPointerException("null name");
                }
                if (ownerId == null) {
                    throw new NullPointerException("null ownerId");
                }
                return this.getProperty(ownerId, name);
            }
        };
        Collection<Task> contextTasks = this.taskContext.getTasks();
        HashMap<String, Task> map = new HashMap<String, Task>();
        for (Task task : contextTasks) {
            String taskId = task.getId();
            if (taskId == null) {
                throw new FSMException("null task id from " + task);
            }
            if (map.containsKey(taskId)) {
                throw new FSMException("duplicate task id from " + task);
            }
            map.put(taskId, task);
            try {
                resolver.addDependency((Object)taskId, null);
            }
            catch (DependencyResolverException dre) {
                throw new FSMException(dre);
            }
            taskIdLocal.set(taskId);
            task.prepare(transitionContext);
            taskIdLocal.set(null);
        }
        List idGroups = resolver.getVerticalGroups();
        for (List idGroup : idGroups) {
            Task[] tasks = new Task[idGroup.size()];
            for (int i = 0; i < tasks.length; ++i) {
                tasks[i] = (Task)map.get(idGroup.get(i));
            }
            this.perform(transitionContext, tasks);
        }
    }

    protected void perform(TransitionContext context, Task ... tasks) throws FSMException {
        for (Task task : tasks) {
            task.perform(context);
        }
    }
}

