/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.Task;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskContext {
    private static final String TASK_INDEX_FILENAME = "task.index";
    protected static final ResourceLoader DEFAULT_RESOURCE_LOADER = new ResourceLoader(){

        public InputStream load(ClassLoader classLoader, String resourceName) throws IOException, FSMException {
            if (classLoader == null) {
                throw new NullPointerException("null classLoader");
            }
            if (resourceName == null) {
                throw new NullPointerException("null resourceName");
            }
            if (resourceName.trim().isEmpty()) {
                throw new IllegalArgumentException("empty resourceName");
            }
            InputStream resourceStream = classLoader.getResourceAsStream(resourceName);
            if (resourceName == null) {
                throw new FSMException("failed to find resource: " + resourceName);
            }
            return resourceStream;
        }
    };
    private final Task[] tasks;

    protected static Class<?>[] load(String contextPath, ClassLoader classLoader) throws FSMException {
        return TaskContext.load(contextPath, classLoader, DEFAULT_RESOURCE_LOADER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Class<?>[] load(String contextPath, ClassLoader classLoader, ResourceLoader resourceLoader) throws FSMException {
        if (contextPath == null) {
            throw new NullPointerException("null contextPath");
        }
        if (classLoader == null) {
            throw new NullPointerException("null classLoader");
        }
        if (resourceLoader == null) {
            throw new NullPointerException("null resourceLoader");
        }
        HashSet<String> packageNames = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(contextPath, ":");
        while (tokenizer.hasMoreTokens()) {
            String packageName = tokenizer.nextToken();
            if (packageName.trim().isEmpty()) continue;
            packageNames.add(packageName);
        }
        if (packageNames.isEmpty()) {
            throw new FSMException("no package names parsed");
        }
        ArrayList classes = new ArrayList();
        for (String packageName : packageNames) {
            String resourceName = packageName.replace('.', '/') + "/" + TASK_INDEX_FILENAME;
            try {
                InputStream resourceStream = resourceLoader.load(classLoader, resourceName);
                if (resourceStream == null) {
                    throw new FSMException("resourceLoader returned null?");
                }
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, "UTF-8"));
                    try {
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                            String className = packageName + "." + line;
                            try {
                                classes.add(classLoader.loadClass(className));
                            }
                            catch (ClassNotFoundException cnfe) {
                                throw new FSMException(cnfe);
                            }
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                finally {
                    resourceStream.close();
                }
            }
            catch (IOException ioe) {
                throw new FSMException(ioe);
            }
        }
        if (classes.isEmpty()) {
            throw new FSMException("no task classes are loaded");
        }
        return classes.toArray(new Class[classes.size()]);
    }

    protected static Task[] instantiate(Class<?>[] classes) throws FSMException {
        if (classes == null) {
            throw new NullPointerException("null classes");
        }
        ArrayList<Task> taskList = new ArrayList<Task>(classes.length);
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i] == null) {
                throw new NullPointerException("null at classes[" + i + "]");
            }
            if (!Task.class.isAssignableFrom(classes[i])) {
                throw new IllegalArgumentException("classes[" + i + "](" + classes[i] + ") is not assignable to " + Task.class);
            }
            try {
                Constructor<Task> constructor = classes[i].asSubclass(Task.class).getConstructor(null);
                try {
                    Task task = constructor.newInstance(null);
                    String id = task.getId();
                    if (id == null) {
                        throw new FSMException("null task id at [" + i + "]");
                    }
                    taskList.add(task);
                }
                catch (InstantiationException ie) {
                    throw new FSMException(ie);
                }
                catch (IllegalAccessException iae) {
                    throw new FSMException(iae);
                }
                catch (InvocationTargetException ite) {
                    throw new FSMException(ite);
                }
            }
            catch (NoSuchMethodException nsme) {
                throw new FSMException(nsme);
            }
            for (int j = 0; j < i; ++j) {
                if (!classes[j].equals(classes[i])) continue;
                throw new IllegalArgumentException("duplicate class: " + classes[i]);
            }
        }
        Task[] tasks = new Task[taskList.size()];
        taskList.toArray(tasks);
        return tasks;
    }

    protected TaskContext(Class<?>[] classes) throws FSMException {
        if (classes == null) {
            throw new NullPointerException("null taskClasses");
        }
        this.tasks = TaskContext.instantiate(classes);
    }

    public Collection<Task> getTasks() throws FSMException {
        return Arrays.asList(this.tasks);
    }

    protected static interface ResourceLoader {
        public InputStream load(ClassLoader var1, String var2) throws IOException, FSMException;
    }
}

