/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.State;

public class Transition {
    private final State source;
    private final State target;

    public Transition(State source, State target) {
        if (source == null) {
            throw new NullPointerException("null source");
        }
        if (target == null) {
            throw new NullPointerException("null target");
        }
        if (source.equals(target)) {
            throw new IllegalArgumentException("source is equlas to target");
        }
        this.source = source;
        this.target = target;
    }

    public final State getSource() {
        return this.source;
    }

    public final State getTarget() {
        return this.target;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Transition)) {
            return false;
        }
        Transition transition = (Transition)obj;
        if (!this.source.equals(transition.getSource())) {
            return false;
        }
        return this.target.equals(transition.getTarget());
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.source.hashCode();
        hashCode = 37 * hashCode + this.target.hashCode();
        return hashCode;
    }

    public String toString() {
        return "Transition[" + this.source + "->" + this.target + "]";
    }
}

