/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.Task;
import com.googlecode.jinahya.util.fsm.Transition;
import com.googlecode.jinahya.util.fsm.TransitionContext;
import com.googlecode.jinahya.util.fsm.TransitionMatcher;

public abstract class SwitchTask
extends Task {
    private final TransitionMatcher[] onMatchers;
    private final TransitionMatcher[] offMatchers;
    private boolean on = false;

    public SwitchTask(String id, TransitionMatcher[] onMatchers, TransitionMatcher[] offMatchers) {
        super(id);
        if (onMatchers == null) {
            throw new NullPointerException("null onMatchers");
        }
        if (onMatchers.length == 0) {
            throw new NullPointerException("empty onMatchers");
        }
        if (offMatchers == null) {
            throw new NullPointerException("null offMatchers");
        }
        if (offMatchers.length == 0) {
            throw new NullPointerException("empty offMatchers");
        }
        this.onMatchers = onMatchers;
        this.offMatchers = offMatchers;
    }

    public void prepare(TransitionContext context) throws FSMException {
        if (context == null) {
            throw new NullPointerException("null context");
        }
        Transition transition = context.getTransition();
        if (this.on) {
            if (transition.matchesAny(this.offMatchers)) {
                this.prepareOff(context);
            }
        } else if (transition.matchesAny(this.onMatchers)) {
            this.prepareOn(context);
        }
    }

    protected abstract void prepareOn(TransitionContext var1) throws FSMException;

    protected abstract void prepareOff(TransitionContext var1) throws FSMException;

    public void perform(TransitionContext context) throws FSMException {
        if (context == null) {
            throw new NullPointerException("null context");
        }
        Transition transition = context.getTransition();
        if (this.on) {
            if (transition.matchesAny(this.offMatchers)) {
                this.on = false;
                this.performOff(context);
            }
        } else if (transition.matchesAny(this.onMatchers)) {
            this.on = true;
            this.performOn(context);
        }
    }

    protected abstract void performOn(TransitionContext var1) throws FSMException;

    protected abstract void performOff(TransitionContext var1) throws FSMException;
}

