/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.Task;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskContext {
    private static final String TASK_INDEX_FILENAME = "task.index";
    protected static final ResourceLoader DEFAULT_RESOURCE_LOADER = new ResourceLoader(){

        public InputStream load(ClassLoader classLoader, String resourceName) throws IOException, FSMException {
            if (classLoader == null) {
                throw new NullPointerException("null classLoader");
            }
            if (resourceName == null) {
                throw new NullPointerException("null resourceName");
            }
            if (resourceName.trim().isEmpty()) {
                throw new IllegalArgumentException("empty resourceName");
            }
            InputStream resourceStream = classLoader.getResourceAsStream(resourceName);
            if (resourceName == null) {
                throw new FSMException("failed to find resource: " + resourceName);
            }
            return resourceStream;
        }
    };
    private final Set<Class<? extends Task>> classes;
    private volatile Collection<Task> tasks = null;

    protected static Set<Class<? extends Task>> load(String contextPath, ClassLoader classLoader) throws FSMException {
        return TaskContext.load(contextPath, classLoader, DEFAULT_RESOURCE_LOADER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Set<Class<? extends Task>> load(String contextPath, ClassLoader classLoader, ResourceLoader resourceLoader) throws FSMException {
        if (contextPath == null) {
            throw new NullPointerException("null contextPath");
        }
        if (classLoader == null) {
            throw new NullPointerException("null classLoader");
        }
        if (resourceLoader == null) {
            throw new NullPointerException("null resourceLoader");
        }
        HashSet<String> packageNames = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(contextPath, ":");
        while (tokenizer.hasMoreTokens()) {
            String packageName = tokenizer.nextToken();
            if (packageName.trim().isEmpty()) continue;
            packageNames.add(packageName);
        }
        if (packageNames.isEmpty()) {
            throw new FSMException("no package names parsed");
        }
        HashSet<Class<? extends Task>> classes = new HashSet<Class<? extends Task>>();
        for (String packageName : packageNames) {
            String resourceName = packageName.replace('.', '/') + "/" + TASK_INDEX_FILENAME;
            try {
                InputStream resourceStream = resourceLoader.load(classLoader, resourceName);
                if (resourceStream == null) {
                    throw new FSMException("resourceLoader returned null?");
                }
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, "UTF-8"));
                    try {
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                            String className = packageName + "." + line;
                            try {
                                Class<?> clazz = classLoader.loadClass(className);
                                try {
                                    classes.add(clazz.asSubclass(Task.class));
                                }
                                catch (ClassCastException cce) {
                                    throw new FSMException(clazz + ") is not assignable to " + Task.class);
                                }
                            }
                            catch (ClassNotFoundException cnfe) {
                                throw new FSMException("failed to load class: " + className, cnfe);
                            }
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                finally {
                    resourceStream.close();
                }
            }
            catch (IOException ioe) {
                throw new FSMException(ioe);
            }
        }
        return classes;
    }

    protected static Collection<Task> instantiate(Set<Class<? extends Task>> classes) throws FSMException {
        if (classes == null) {
            throw new NullPointerException("null classes");
        }
        HashSet<String> taskIdSet = new HashSet<String>();
        ArrayList<Task> taskList = new ArrayList<Task>(classes.size());
        for (Class<? extends Task> clazz : classes) {
            if (clazz == null) {
                throw new NullPointerException("null task class");
            }
            try {
                Constructor<? extends Task> constructor = clazz.getConstructor(null);
                try {
                    Task task = constructor.newInstance(null);
                    String taskId = task.getId();
                    if (!taskIdSet.add(taskId)) {
                        throw new FSMException("duplicate task id: " + taskId);
                    }
                    taskList.add(task);
                }
                catch (InstantiationException ie) {
                    throw new FSMException(ie);
                }
                catch (IllegalAccessException iae) {
                    throw new FSMException(iae);
                }
                catch (InvocationTargetException ite) {
                    throw new FSMException(ite);
                }
            }
            catch (NoSuchMethodException nsme) {
                throw new FSMException(nsme);
            }
        }
        return taskList;
    }

    public static TaskContext newInstance(String contextPath) throws FSMException {
        return TaskContext.newInstance(contextPath, DEFAULT_RESOURCE_LOADER);
    }

    public static TaskContext newInstance(String contextPath, ResourceLoader resourceLoader) throws FSMException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            throw new FSMException("no context class loader");
        }
        return TaskContext.newInstance(contextPath, classLoader, resourceLoader);
    }

    public static TaskContext newInstance(String contextPath, ClassLoader classLoader) throws FSMException {
        return TaskContext.newInstance(contextPath, classLoader, DEFAULT_RESOURCE_LOADER);
    }

    public static TaskContext newInstance(String contextPath, ClassLoader classLoader, ResourceLoader resourceLoader) throws FSMException {
        return new TaskContext(TaskContext.load(contextPath, classLoader, resourceLoader));
    }

    protected TaskContext(Set<Class<? extends Task>> classes) {
        if (classes == null) {
            throw new NullPointerException("null taskClasses");
        }
        this.classes = new HashSet<Class<? extends Task>>(classes);
    }

    public synchronized Collection<Task> getTasks() throws FSMException {
        if (this.tasks == null) {
            this.tasks = TaskContext.instantiate(this.classes);
        }
        return Collections.unmodifiableCollection(this.tasks);
    }

    public synchronized Map<String, Task> getTaskMap() throws FSMException {
        HashMap<String, Task> taskMap = new HashMap<String, Task>();
        for (Task task : this.getTasks()) {
            taskMap.put(task.getId(), task);
        }
        return Collections.unmodifiableMap(taskMap);
    }

    protected static interface ResourceLoader {
        public InputStream load(ClassLoader var1, String var2) throws IOException, FSMException;
    }
}

